package com.walker.semantics;

/**
 * 描述：语义分析管理器，主要负责自定义关键词的同步、查找等。
 * @author 时克英
 * @date 2020年11月10日 上午8:50:27
 */

public interface SemanticsManager {

	/**
	 * 向系统注册自定义关键词。</p>
	 * 新添加的关键词有一定规则要求，具体如下：
	 * <pre>
	 * 1.指令集中添加的关键词，不一定都是动词，也会有名词，如：目的地、目标等（设置载具目的地）
	 * 2.指令集中添加的关键词，需要校验，不能改变原有动词词性，对于不容易确定的词性，可以设置为自定义动词(mv)
	 * 3.资源集中添加的关键词，统一设置为自定义名词(mn)
	 * </pre>
	 * @param sceneContextId 场景ID，对于公共关键词，该值设置为0
	 * @param word
	 * @param speechPart
	 */
	void registerKeyWord(int sceneContextId, String word, SpeechPart speechPart) throws SemanticsException;
	
	/**
	 * 删除已注册的自定义关键词
	 * @param sceneContextId 场景ID，对于公共关键词，该值设置为0
	 * @param word
	 */
	void removeKeyWord(int sceneContextId, String word);
	
	void startup();
}
