package com.walker.semantics;

import java.util.List;

/**
 * 摘要元数据定义
 * @author 时克英
 * @date 2023-08-31
 */
public class SummaryMeta {

    /**
     * 抽取的标题
     * @return
     */
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * 抽取的关键内容
     * @return
     */
    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    /**
     * 带标签的内容，如：提供的标签是，<start><end>，则内容中关键词会打上该标记。
     * @return
     */
    public String getTagSummary() {
        return tagSummary;
    }

    public void setTagSummary(String tagSummary) {
        this.tagSummary = tagSummary;
    }

    /**
     * 返回关键词列表，用于调试。
     * @return
     */
    public List<WordKey> getWordKeyList() {
        return wordKeyList;
    }

    public void setWordKeyList(List<WordKey> wordKeyList) {
        this.wordKeyList = wordKeyList;
    }

    private String title;
    private String summary;
    private String tagSummary;
    private List<WordKey> wordKeyList;
}
