package com.walker.semantics;

/**
 * 摘要输入对象定义。
 * @author 时克英
 * @date 2023-08-31
 */
public class SummaryQuery {

    /**
     * 要提取摘要的原始输入内容
     * @return
     */
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 输入的关键词，可选。例如：已知会包含的关键字，能增强抽取意义。
     * @return
     */
    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    /**
     * 设置关键词最小分值，小于该分值的词会忽略。
     * @return
     */
    public double getMinScore() {
        return minScore;
    }

    public void setMinScore(double minScore) {
        this.minScore = minScore;
    }

    /**
     * 设置开始标签
     * @return
     */
    public String getBeginTag() {
        return beginTag;
    }

    public void setBeginTag(String beginTag) {
        this.beginTag = beginTag;
    }

    /**
     * 设置结束标签
     * @return
     */
    public String getEndTag() {
        return endTag;
    }

    public void setEndTag(String endTag) {
        this.endTag = endTag;
    }

    /**
     * 返回设置最大摘要长度，默认：300字
     * @return
     */
    public int getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    private int maxLength = 255;
    private String content;
    private String keywords;
    private double minScore = 2;
    private String beginTag;
    private String endTag;

    @Override
    public String toString() {
        return "SummaryQuery{" +
                "content='" + content + '\'' +
                ", keywords='" + keywords + '\'' +
                ", minScore=" + minScore +
                ", beginTag='" + beginTag + '\'' +
                ", endTag='" + endTag + '\'' +
                '}';
    }
}
