package com.walker.semantics;

import java.io.Serializable;

/**
 * 文本相似搜索结果对象。
 * @date 2022-11-03
 */
public class TextSimilar implements Serializable {

    private String id;
    private double dis = 0;

    private String text;

    /**
     * 是否完全匹配，如果完全匹配则后续的就不再检查，直接输出结果。
     * @return
     * @date 2023-08-17
     */
    public boolean isPerfect() {
        return perfect;
    }

    public void setPerfect(boolean perfect) {
        this.perfect = perfect;
    }

    // 是否完全匹配
    private boolean perfect = false;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getDis() {
        return dis;
    }

    public void setDis(double dis) {
        this.dis = dis;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return "TextSimilar{" +
                "id='" + id + '\'' +
                ", dis=" + dis +
                ", text='" + text + '\'' +
                '}';
    }
}
