package com.walker.semantics;

import com.walker.infrastructure.arguments.Variable;

import java.util.List;

/**
 * 文本相似搜索引擎定义。
 * <pre>
 *     1)该对象能实现输入一个段话（或词组）返回（库中）最匹配的语句集合
 *     2)给定一段话，返回其中包含的关键词内容。
 * </pre>
 * @author 时克英
 * @date 2023-08-17
 */
public interface TextSimilarEngine {

    SemanticsManager getSemanticsManager();

    /**
     * 搜索已有库，并返回与输入词组最匹配的记录集合。
     * @param text 输入的词组
     * @return
     * @date 2023-08-17
     * @date 2023-09-12 添加参数：归属人
     */
    List<TextSimilar> search(String[] text, String owner);

    /**
     * 加载用户业务词库。初始化业务库，Bean在创建实例后需要调用该方法完成预加载。
     * <pre>
     *     1) key = 词条或业务ID
     *     2) value = 关键词，多个用英文逗号分隔
     * </pre>
     * @return
     */
    void loadLibrary();

    /**
     * 向词库注册关键词
     * @param words 关键词集合
     * @param speechPart 词性
     */
    void registerKeyword(String[] words, SpeechPart speechPart);

    /**
     * 从词库删除关键词
     * @param keyword
     */
    void removeKeyword(String keyword);

    /**
     * 输入一段话，提取出分词集合。
     * @param input
     * @return
     */
    List<WordMeta> extract(String input);

}
