package com.walker.semantics.support;

import com.walker.semantics.SemanticsException;
import com.walker.semantics.SemanticsManager;
import com.walker.semantics.SpeechPart;
import org.ansj.domain.Result;
import org.ansj.library.DicLibrary;
import org.ansj.splitWord.analysis.DicAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 描述：默认语义管理器实现
 * @author 时克英
 * @date 2020年11月10日 上午9:52:13
 */

public class DefaultSemanticsManager implements SemanticsManager {

	protected final transient Logger logger = LoggerFactory.getLogger(getClass());

	@Override
	public void startup() {
		// 内置一些特殊的指令，对于系统管理来说这些指令很难维护，所以直接集成
//		DicLibrary.insert(DicLibrary.DEFAULT, "在哪", SpeechPart.INDEX_MY_V, 1000);
		this.loadKeywordFromPersistence();
	}

	@Override
	public void registerKeyWord(int sceneContextId, String word, SpeechPart speechPart) throws SemanticsException {
		Result result = DicAnalysis.parse(word);
		int wordSize = result.getTerms().size();
		if(wordSize == 0){
			throw new SemanticsException("注册的关键词为空：" + word);
		}
//		logger.debug("====== " + result);
//
//		WordSet wordSet = new WordSet(result.getTerms());
//		boolean syncToVoice = false;
//
//		if(speechPart == SpeechPart.MY_V){
//			syncToVoice = this.doRegisterInstruction(wordSet);
//			logger.info("注册了指令词：" + wordSet);
//
//		} else if(speechPart == SpeechPart.MY_N){
//			syncToVoice = this.doRegisterResourceObject(wordSet);
//			logger.info("注册了资源词：" + wordSet);
//
//		} else if(speechPart == SpeechPart.MY_PLACE){
//			syncToVoice = this.doRegisterResourcePlace(wordSet);
//			logger.info("注册了地点词：" + wordSet);
//
//		} else {
//			throw new InteracupException("注册关键词未支持类型：" + speechPart.name());
//		}

		boolean syncToVoice = false;

		if(speechPart == SpeechPart.MY_V){
//			if(wordSet.isInstruction()){
//				throw new InteracupException("已经是自定义指令词了，无需重复定义：" + wordSet);
//			}
			DicLibrary.insert(DicLibrary.DEFAULT, word, SpeechPart.INDEX_MY_V, 1000);

		} else if(speechPart == SpeechPart.MY_N){
//			if(wordSet.isResource()){
//				throw new InteracupException("当前词已经是资源词，无需在重复定义：" + wordSet);
//			}
			DicLibrary.insert(DicLibrary.DEFAULT, word, SpeechPart.INDEX_MY_N, 1000);

		} else if(speechPart == SpeechPart.MY_PLACE){
//			if(wordSet.isPlace()){
//				throw new InteracupException("当前词已经是地点词，无需在重复定义：" + wordSet);
//			}
			DicLibrary.insert(DicLibrary.DEFAULT, word, SpeechPart.INDEX_MY_PLACE, 100);

		} else if(speechPart == SpeechPart.MY_V_AUX){
			// 辅助指令词
			DicLibrary.insert(DicLibrary.DEFAULT, word, SpeechPart.INDEX_MY_V_AUX, 1000);

		} else if(speechPart == SpeechPart.MY_ROAD){
			// 辅助指令词
			DicLibrary.insert(DicLibrary.DEFAULT, word, SpeechPart.INDEX_MY_ROAD, 200);

		} else {
			throw new SemanticsException("注册关键词未支持类型：" + speechPart.name());
		}
//		logger.info("注册了关键词：" + word);

		// 业务回调
		this.afterRegisterKeyWord(word, speechPart);

		// 同步到语音库
		if(syncToVoice){
			logger.info("已同步到语音库：" + word);
		}
	}

	@Override
	public void removeKeyWord(int sceneContextId, String word) {
		DicLibrary.delete(DicLibrary.DEFAULT, word);
	}

//	/**
//	 * 注册自定义指令关键词
//	 * @param wordSet
//	 * @return
//	 * @throws InteracupException
//	 */
//	private boolean doRegisterInstruction(WordSet wordSet) throws InteracupException{
//		if(wordSet.size() > 1){
//			throw new InteracupException("指令关键词一次只能添加一个，当前：" + wordSet.size() + "个");
//		}
//		if(wordSet.isInstruction()){
////			throw new InteracupException("已经是自定义指令词了，无需重复定义：" + wordSet);
//			logger.warn("已经是自定义指令词了，无需重复定义：" + wordSet);
//			return false;
//		}
//		if(!wordSet.hasAvailableInstruction()){
//			throw new InteracupException("不存在可用的指令词!指令词只能是动词或名词，请重新输入：" + wordSet);
//		}
//		DicLibrary.insert(DicLibrary.DEFAULT, wordSet.getFirstText(), SpeechPart.INDEX_MY_V, 1000);
//		return false;
//	}
//
//	/**
//	 * 注册自定义活动资源名称，非地点类，如：车辆、行人、道路
//	 * @param wordSet
//	 * @return
//	 */
//	private boolean doRegisterResourceObject(WordSet wordSet) throws InteracupException{
//		if(wordSet.isResource()){
//			throw new InteracupException("当前词已经是资源词，无需在重复定义：" + wordSet);
//		}
//		boolean syncToVoice = false;
//		if(wordSet.size() > 1){
//			// 如果是多个词联合，需要同步到语音输入库中
//			syncToVoice = true;
//		}
//		DicLibrary.insert(DicLibrary.DEFAULT, wordSet.getText(), SpeechPart.INDEX_MY_N, 1000);
//		return syncToVoice;
//	}
//
//	private boolean doRegisterResourcePlace(WordSet wordSet) throws InteracupException{
//		if(wordSet.isPlace()){
//			throw new InteracupException("当前词已经是地点词，无需在重复定义：" + wordSet);
//		}
//		boolean syncToVoice = false;
//		if(wordSet.size() > 1){
//			// 如果是多个词联合，需要同步到语音输入库中
//			syncToVoice = true;
//		}
//		DicLibrary.insert(DicLibrary.DEFAULT, wordSet.getText(), SpeechPart.INDEX_MY_PLACE, 1000);
//		return syncToVoice;
//	}

	/**
	 * 从持久化存储中，加载已有的自定义关键词
	 */
	protected void loadKeywordFromPersistence(){
		DicLibrary.insert(DicLibrary.DEFAULT, "盖亚", SpeechPart.INDEX_MY_N, 1000);
		// 时间词
		DicLibrary.insert(DicLibrary.DEFAULT, "前天", SpeechPart.INDEX_T_TIME, 1000);
		DicLibrary.insert(DicLibrary.DEFAULT, "后天", SpeechPart.INDEX_T_TIME, 1000);
		DicLibrary.insert(DicLibrary.DEFAULT, "大后天", SpeechPart.INDEX_T_TIME, 1000);
	}

	/**
	 * 注册自定义关键词之后，业务可回调
	 * @param text
	 * @param speechPart
	 */
	protected void afterRegisterKeyWord(String text, SpeechPart speechPart){

	}

	/**
	 * 删除自定义关键词之后，业务可回调
	 * @param text
	 */
	protected void afterRemoveKeyWord(String text){

	}

	/**
	private class WordSet{
		private List<WordMeta> textList = new ArrayList<>(4);
		public WordSet(List<Term> terms){
			SpeechPart speechPart = null;
			WordMeta wordMeta = null;
			for(Term t : terms){
				speechPart = SpeechPart.toSpeechPart(t.getNatureStr());
				// 只处理关注的词性
//				if(speechPart.isFocus()){
					wordMeta = new WordMeta(t.getName(), speechPart);
					if(!this.textList.contains(wordMeta)){
						this.textList.add(wordMeta);
					}
//				}
			}
		}

		public int size(){
			return this.textList.size();
		}

		public boolean isInstruction(){
			if(this.size() == 1 && this.textList.get(0).isInstruction()){
				return true;
			}
			return false;
		}

		public boolean isPlace(){
			if(this.size() == 1 && this.textList.get(0).isPlace()){
				return true;
			}
			return false;
		}

		public boolean isResource(){
			if(this.size() == 1 && this.textList.get(0).isResource()){
				return true;
			}
			return false;
		}

		@Override
		public String toString(){
			StringBuilder sb = new StringBuilder("[");
			for(WordMeta wm : this.textList){
				sb.append(wm.getText()).append(StringUtils.DEFAULT_SPLIT_SEPARATOR);
			}
			sb.append("]");
			return sb.toString();
		}
	}
*/
}
