package com.walker.semantics.util;

import com.walker.infrastructure.utils.StringUtils;

public class SemanticsUtils {

    public static final String EMPTY_TEXT = "";

    /**
     * 返回给定关键词的Hash码集合
     * @param words 一组关键词，用英文逗号分隔
     * @return
     * @date 2023-08-17
     */
    public static final Integer[] acquireWordHashCode(String words){
        if(StringUtils.isEmpty(words)){
            throw new IllegalArgumentException("words不存在");
        }
        String[] wordArray = StringUtils.commaDelimitedListToStringArray(words);
        Integer[] data = new Integer[wordArray.length];
        for(int i=0; i<wordArray.length; i++){
            data[i] = wordArray[i].hashCode();
        }
        return data;
    }

    public static boolean isEmpty(String text){
        if(text == null || text.equals(EMPTY_TEXT)){
            return true;
        }
        return false;
    }
}
