/*
 * Decompiled with CFR 0.152.
 */
package com.walker.semantics;

import com.walker.semantics.SpeechPart;
import com.walker.semantics.WordMeta;
import com.walker.semantics.util.SemanticsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.splitWord.analysis.DicAnalysis;

public class InputWord {
    private String srcText;
    private List<WordMeta> wordList = new ArrayList<WordMeta>(8);
    private int total = 0;
    private Map<String, WordMeta> wordMetaCache = new HashMap<String, WordMeta>(16);
    private int sceneContextId = 0;
    private String user;

    public InputWord(String srcWords) {
        if (SemanticsUtils.isEmpty(srcWords)) {
            throw new IllegalArgumentException("srcWords is required!");
        }
        this.srcText = srcWords;
        Result result = DicAnalysis.parse((String)this.srcText);
        SpeechPart sp = null;
        for (Term t : result.getTerms()) {
            sp = SpeechPart.toSpeechPart(t.getNatureStr());
            if (!sp.isFocus()) continue;
            this.addWordMeta(new WordMeta(t.getName(), sp));
        }
    }

    public void addWordMeta(WordMeta wm) {
        this.wordMetaCache.put(wm.getText(), wm);
        if (this.wordList.contains(wm)) {
            wm.setDuplication(true);
        }
        wm.setIndex(this.total);
        this.wordList.add(wm);
        ++this.total;
    }

    public String getSrcText() {
        return this.srcText;
    }

    public List<WordMeta> getWordMetaList() {
        return this.wordList;
    }

    public int getTotal() {
        return this.total;
    }

    public Map<String, WordMeta> getWordMetaMap() {
        return this.wordMetaCache;
    }

    public int getTextLength() {
        return this.srcText.length();
    }

    public WordMeta getWordMeta(int index) {
        if (index >= this.total) {
            throw new IllegalArgumentException("\u8d85\u8fc7\u7d22\u5f15\uff0c\u65e0\u6cd5\u8fd4\u56deWordMeta\uff1a" + index + ", total=" + this.total);
        }
        return this.wordList.get(index);
    }

    public String toString() {
        return this.wordList.toString();
    }
}

