/*
 * Decompiled with CFR 0.152.
 */
package com.walker.semantics;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SpeechPart {
    A_ADJECTIVE{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    B_DISTIN{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    C_CONJUNCTION{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    D_ADVERB{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    E_INTERJECTION{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    F_POSITION{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    M_NUMBER{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    MQ_NUMBER_UNIT{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    N_NAME{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    NS_PLACENAME{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    NT_NAMETIME{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    NZ_NAMESTATUS{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    O_ANO{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    P_PREPOSITION{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    Q_QUANTIFIER{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    QV{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    R_PRONOUN{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    RYS{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    S_PLACE{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    T_TIME{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    U_AUXILIARY{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    V_VERB{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    VN_VERBNAME{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    Y_STATEMENT{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    Z_STATUS{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    W_PUNCTUATION{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    EN_ENGLISH{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    X_UNKNOWN{

        @Override
        public boolean isFocus() {
            return false;
        }
    }
    ,
    MY_N{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    MY_V{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    MY_V_AUX{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    MY_PLACE{

        @Override
        public boolean isFocus() {
            return true;
        }
    }
    ,
    MY_ROAD{

        @Override
        public boolean isFocus() {
            return true;
        }
    };

    public static final String INDEX_A_ADJECTIVE = "a";
    public static final String INDEX_B_DISTIN = "b";
    public static final String INDEX_C_CONJUNCTION = "c";
    public static final String INDEX_D_ADVERB = "d";
    public static final String INDEX_E_INTERJECTION = "e";
    public static final String INDEX_F_POSITION = "f";
    public static final String INDEX_M_NUMBER = "m";
    public static final String INDEX_MQ_NUMBER_UNIT = "mq";
    public static final String INDEX_N_NAME = "n";
    public static final String INDEX_NS_PLACENAME = "ns";
    public static final String INDEX_NZ_NAMESTATUS = "nz";
    public static final String INDEX_NT_NAMETIME = "nt";
    public static final String INDEX_O_ANO = "o";
    public static final String INDEX_P_PREPOSITION = "p";
    public static final String INDEX_Q_QUANTIFIER = "q";
    public static final String INDEX_QV = "qv";
    public static final String INDEX_R_PRONOUN = "r";
    public static final String INDEX_RYS = "rys";
    public static final String INDEX_S_PLACE = "s";
    public static final String INDEX_T_TIME = "t";
    public static final String INDEX_QT_TIME_UNIT = "qt";
    public static final String INDEX_U_AUXILIARY = "u";
    public static final String INDEX_U_DEL = "ude1";
    public static final String INDEX_V_VERB = "v";
    public static final String INDEX_VI = "vi";
    public static final String INDEX_VN_VERBNAME = "vn";
    public static final String INDEX_Y_STATEMENT = "y";
    public static final String INDEX_Z_STATUS = "z";
    public static final String INDEX_W_PUNCTUATION = "w";
    public static final String INDEX_EN_ENGLISH = "en";
    public static final String INDEX_X_UNKNOWN = "x";
    public static final String INDEX_MY_N = "mn";
    public static final String INDEX_MY_V = "mv";
    public static final String INDEX_MY_V_AUX = "mv_aux";
    public static final String INDEX_MY_PLACE = "mp";
    public static final String INDEX_MY_ROAD = "mr";

    public boolean isFocus() {
        throw new AbstractMethodError();
    }

    public static SpeechPart toSpeechPart(String index) {
        if (index.equals(INDEX_A_ADJECTIVE)) {
            return A_ADJECTIVE;
        }
        if (index.equals(INDEX_B_DISTIN)) {
            return B_DISTIN;
        }
        if (index.equals(INDEX_C_CONJUNCTION) || index.equals("cc")) {
            return C_CONJUNCTION;
        }
        if (index.equals(INDEX_D_ADVERB)) {
            return D_ADVERB;
        }
        if (index.equals(INDEX_E_INTERJECTION)) {
            return E_INTERJECTION;
        }
        if (index.equals(INDEX_F_POSITION)) {
            return F_POSITION;
        }
        if (index.equals(INDEX_M_NUMBER)) {
            return M_NUMBER;
        }
        if (index.equals(INDEX_MQ_NUMBER_UNIT)) {
            return MQ_NUMBER_UNIT;
        }
        if (index.startsWith(INDEX_N_NAME)) {
            return N_NAME;
        }
        if (index.equals(INDEX_NS_PLACENAME)) {
            return NS_PLACENAME;
        }
        if (index.equals(INDEX_NZ_NAMESTATUS)) {
            return NZ_NAMESTATUS;
        }
        if (index.equals(INDEX_NT_NAMETIME)) {
            return NT_NAMETIME;
        }
        if (index.equals(INDEX_O_ANO)) {
            return O_ANO;
        }
        if (index.equals(INDEX_P_PREPOSITION)) {
            return P_PREPOSITION;
        }
        if (index.equals(INDEX_Q_QUANTIFIER)) {
            return Q_QUANTIFIER;
        }
        if (index.equals(INDEX_QV)) {
            return QV;
        }
        if (index.startsWith(INDEX_R_PRONOUN)) {
            return R_PRONOUN;
        }
        if (index.equals(INDEX_RYS)) {
            return RYS;
        }
        if (index.equals(INDEX_S_PLACE)) {
            return S_PLACE;
        }
        if (index.equals(INDEX_T_TIME) || index.equals(INDEX_QT_TIME_UNIT)) {
            return T_TIME;
        }
        if (index.startsWith(INDEX_U_AUXILIARY)) {
            return U_AUXILIARY;
        }
        if (index.startsWith(INDEX_V_VERB)) {
            return V_VERB;
        }
        if (index.equals(INDEX_VN_VERBNAME)) {
            return VN_VERBNAME;
        }
        if (index.equals(INDEX_Y_STATEMENT)) {
            return Y_STATEMENT;
        }
        if (index.equals(INDEX_Z_STATUS)) {
            return Z_STATUS;
        }
        if (index.equals(INDEX_W_PUNCTUATION)) {
            return W_PUNCTUATION;
        }
        if (index.equals(INDEX_EN_ENGLISH)) {
            return EN_ENGLISH;
        }
        if (index.equals(INDEX_X_UNKNOWN)) {
            return X_UNKNOWN;
        }
        if (index.equals(INDEX_MY_N)) {
            return MY_N;
        }
        if (index.equals(INDEX_MY_V)) {
            return MY_V;
        }
        if (index.equals(INDEX_MY_V_AUX)) {
            return MY_V_AUX;
        }
        if (index.equals(INDEX_MY_PLACE)) {
            return MY_PLACE;
        }
        if (index.equals(INDEX_MY_ROAD)) {
            return MY_ROAD;
        }
        System.out.println("\u672a\u652f\u6301\u7684\u8bcd\u6027\uff1a" + index);
        return X_UNKNOWN;
    }
}

