/*
 * Decompiled with CFR 0.152.
 */
package com.walker.semantics.support;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.semantics.ExtractorException;
import com.walker.semantics.InputWord;
import com.walker.semantics.SemanticsManager;
import com.walker.semantics.SummaryExtractor;
import com.walker.semantics.SummaryMeta;
import com.walker.semantics.SummaryQuery;
import com.walker.semantics.WordKey;
import java.util.ArrayList;
import java.util.List;
import org.ansj.app.keyword.KeyWordComputer;
import org.ansj.app.keyword.Keyword;
import org.ansj.app.summary.SummaryComputer;
import org.ansj.app.summary.TagContent;
import org.ansj.app.summary.pojo.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSummaryExtractor
implements SummaryExtractor {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private float keywordPercent = 0.4f;
    private SemanticsManager semanticsManager;

    @Override
    public SummaryMeta extract(SummaryQuery query) throws ExtractorException {
        InputWord inputWord;
        if (query == null) {
            throw new ExtractorException("\u672a\u63d0\u4f9b\u62bd\u53d6\u6761\u4ef6\uff0c\u65e0\u6cd5\u5b8c\u6210\u6458\u8981\u62bd\u53d6");
        }
        if (StringUtils.isEmpty((String)query.getContent())) {
            throw new ExtractorException("\u539f\u59cb\u62bd\u53d6\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        if (query.getMinScore() <= 0.0) {
            throw new ExtractorException("\u5173\u952e\u8bcd\u5206\u503c\u5fc5\u987b\u5927\u4e8e0");
        }
        String input = query.getContent();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(input);
        }
        if ((inputWord = new InputWord(input)).getWordMetaList().size() <= 3) {
            throw new ExtractorException("\u8f93\u5165\u5185\u5bb9\u8fc7\u5c11", query.getContent(), true);
        }
        this.logger.debug(inputWord.getWordMetaList().toString());
        String referenceKeywords = null;
        referenceKeywords = StringUtils.isNotEmpty((String)query.getKeywords()) ? query.getKeywords() : this.acquireKeywords(null, input);
        this.logger.debug("referenceKeywords = {}", (Object)referenceKeywords);
        SummaryComputer summaryComputer = new SummaryComputer(query.getMaxLength(), null, input);
        Summary summary = summaryComputer.toSummary(referenceKeywords);
        List keywordList = summary.getKeyWords();
        if (keywordList == null || keywordList.size() <= 1) {
            throw new ExtractorException("\u8f93\u5165\u5185\u5bb9\u8fc7\u5c11", query.getContent(), true);
        }
        double minScore = query.getMinScore();
        StringBuilder title = new StringBuilder();
        ArrayList<WordKey> wordKeyList = new ArrayList<WordKey>(keywordList.size());
        for (Keyword keyword : keywordList) {
            if (!(keyword.getScore() >= minScore)) continue;
            wordKeyList.add(new WordKey(keyword.getScore(), keyword.getName()));
            title.append(keyword.getName());
        }
        SummaryMeta summaryMeta = new SummaryMeta();
        summaryMeta.setTitle(title.toString());
        summaryMeta.setSummary(summary.getSummary());
        summaryMeta.setWordKeyList(wordKeyList);
        if (StringUtils.isNotEmpty((String)query.getBeginTag()) && StringUtils.isNotEmpty((String)query.getEndTag())) {
            TagContent tagContent = new TagContent(query.getBeginTag(), query.getEndTag());
            summaryMeta.setTagSummary(tagContent.tagContent(summary));
        }
        return summaryMeta;
    }

    private String acquireKeywords(String title, String content) {
        KeyWordComputer kwc = new KeyWordComputer(20);
        List result = kwc.computeArticleTfidf(title, content);
        if (result == null || result.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int size = result.size();
        float currentSize = 0.0f;
        for (Keyword kw : result) {
            if (currentSize == 0.0f) {
                sb.append(kw.getName());
                currentSize += 1.0f;
                continue;
            }
            if (!(currentSize / (float)size < this.keywordPercent)) break;
            sb.append(kw.getName());
            currentSize += 1.0f;
        }
        return sb.toString();
    }

    @Override
    public void setSemanticsManager(SemanticsManager semanticsManager) {
        this.semanticsManager = semanticsManager;
    }

    public SemanticsManager getSemanticsManager() {
        return this.semanticsManager;
    }

    public float getKeywordPercent() {
        return this.keywordPercent;
    }

    public void setKeywordPercent(float keywordPercent) {
        this.keywordPercent = keywordPercent;
    }
}

