/*
 * Decompiled with CFR 0.152.
 */
package com.walker.semantics.support;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.semantics.InputWord;
import com.walker.semantics.OwnerTextItem;
import com.walker.semantics.OwnerTextStore;
import com.walker.semantics.SemanticsManager;
import com.walker.semantics.SpeechPart;
import com.walker.semantics.TextSimilar;
import com.walker.semantics.TextSimilarEngine;
import com.walker.semantics.WordMeta;
import com.walker.semantics.util.TextSimilarComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextSimilarEngine
implements TextSimilarEngine {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TextSimilarComparator comparator = new TextSimilarComparator();
    private final Map<String, OwnerTextStore> ownerTextStoreMap = new HashMap<String, OwnerTextStore>(4);
    private SemanticsManager semanticsManager;

    @Override
    public SemanticsManager getSemanticsManager() {
        return this.semanticsManager;
    }

    @Override
    public List<TextSimilar> search(String[] text, String owner) {
        if (StringUtils.isEmpty((String)owner)) {
            throw new IllegalArgumentException("owner\u5fc5\u987b\u8f93\u5165");
        }
        if (text == null || text.length == 0) {
            throw new IllegalArgumentException("text\u5fc5\u987b\u8f93\u5165");
        }
        OwnerTextStore ownerTextStore = this.ownerTextStoreMap.get(owner);
        if (ownerTextStore == null) {
            this.logger.warn("\u6ca1\u6709\u627e\u5230owner\u5173\u952e\u8bcd\u914d\u7f6e\u6570\u636e\uff0cowner=" + owner);
            return null;
        }
        Integer[] inputHashCode = new Integer[text.length];
        for (int i = 0; i < text.length; ++i) {
            inputHashCode[i] = text[i].hashCode();
        }
        ArrayList<TextSimilar> data = new ArrayList<TextSimilar>(8);
        TextSimilar textSimilar = null;
        for (Map.Entry<String, Integer[]> entry : ownerTextStore.getIdAndWordHashCache().entrySet()) {
            textSimilar = this.calculateOneSimilar(inputHashCode, entry.getKey(), entry.getValue(), ownerTextStore.getIdAndTextCache());
            if (textSimilar == null) continue;
            data.add(textSimilar);
            if (!textSimilar.isPerfect()) continue;
            break;
        }
        Collections.sort(data, this.comparator);
        return data;
    }

    protected TextSimilar calculateOneSimilar(Integer[] wordsHash, String id, Integer[] userKeywordHash, Map<String, String> idAndTextCache) {
        int wn = wordsHash.length;
        int rn = userKeywordHash.length;
        TextSimilar textSimilar = new TextSimilar();
        textSimilar.setId(id);
        textSimilar.setText(idAndTextCache.get(id));
        int matchSize = 0;
        if (wn > rn) {
            block0: for (Integer userHashCode : userKeywordHash) {
                for (Integer inputHashCode : wordsHash) {
                    if (userHashCode.intValue() != inputHashCode.intValue()) continue;
                    ++matchSize;
                    continue block0;
                }
            }
            if (matchSize == 0) {
                return null;
            }
            if (matchSize == rn) {
                textSimilar.setDis(rn + 20);
            } else {
                textSimilar.setDis(matchSize + 10);
            }
        } else if (wn == rn) {
            block2: for (Integer userHashCode : userKeywordHash) {
                for (Integer inputHashCode : wordsHash) {
                    if (userHashCode.intValue() != inputHashCode.intValue()) continue;
                    ++matchSize;
                    continue block2;
                }
            }
            if (matchSize == 0) {
                return null;
            }
            if (matchSize == rn) {
                textSimilar.setDis(matchSize + 100);
                textSimilar.setPerfect(true);
            } else {
                textSimilar.setDis(matchSize + 20);
            }
        } else if (wn < rn) {
            block4: for (Integer inputHashCode : wordsHash) {
                for (Integer userHashCode : userKeywordHash) {
                    if (inputHashCode.intValue() != userHashCode.intValue()) continue;
                    ++matchSize;
                    continue block4;
                }
            }
            if (matchSize == 0) {
                return null;
            }
            if (matchSize == wn) {
                textSimilar.setDis(matchSize + 80);
            } else {
                textSimilar.setDis(matchSize + 20);
            }
        }
        return textSimilar;
    }

    @Override
    public void loadLibrary() {
        List<OwnerTextItem> data = this.doLoadUserLibrary();
        if (StringUtils.isEmptyList(data)) {
            this.logger.warn("\u672a\u52a0\u8f7d\u5230\u4efb\u4f55\u7528\u6237\u8bcd\u5e93\uff0cTextSimilarEngine\u53ef\u80fd\u65e0\u6cd5\u6b63\u5e38\u5de5\u4f5c");
            return;
        }
        OwnerTextStore ownerTextStore = null;
        for (OwnerTextItem item : data) {
            ownerTextStore = this.ownerTextStoreMap.get(item.getOwner());
            if (ownerTextStore == null) {
                ownerTextStore = new OwnerTextStore(item.getOwner());
                this.ownerTextStoreMap.put(item.getOwner(), ownerTextStore);
            }
            if (ownerTextStore.getWordHashCode(item.getId()) != null) {
                throw new IllegalArgumentException("\u7528\u6237\u8bcd\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5\u4e1a\u52a1id = " + item.getId() + ", owner =" + item.getOwner());
            }
            ownerTextStore.putWord(item.getId(), item.getText());
        }
    }

    protected abstract List<OwnerTextItem> doLoadUserLibrary();

    @Override
    public void registerKeyword(String[] words, SpeechPart speechPart) {
        this.checkSemanticsManager();
        if (words == null || words.length == 0) {
            throw new IllegalArgumentException("\u8bf7\u8bbe\u7f6ewords");
        }
        if (speechPart == null) {
            speechPart = SpeechPart.MY_N;
        }
        try {
            for (String word : words) {
                this.semanticsManager.registerKeyWord(0, word, speechPart);
            }
        }
        catch (Exception ex) {
            this.logger.error("\u5411\u8bcd\u5e93\u6ce8\u518c\u5173\u952e\u8bcd\uff0c\u51fa\u73b0\u5f02\u5e38:" + ex.getMessage(), (Throwable)ex);
            throw new ApplicationRuntimeException("\u5411\u8bcd\u5e93\u6ce8\u518c\u5173\u952e\u8bcd\uff0c\u51fa\u73b0\u5f02\u5e38:" + ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void removeKeyword(String keyword) {
        this.checkSemanticsManager();
        this.semanticsManager.removeKeyWord(0, keyword);
    }

    @Override
    public List<WordMeta> extract(String input) {
        if (StringUtils.isEmpty((String)input)) {
            throw new IllegalArgumentException("input\u5fc5\u987b\u8f93\u5165");
        }
        input = input.trim().toLowerCase();
        InputWord inputWord = new InputWord(input);
        return inputWord.getWordMetaList();
    }

    public void setSemanticsManager(SemanticsManager semanticsManager) {
        this.semanticsManager = semanticsManager;
    }

    private void checkSemanticsManager() {
        if (this.semanticsManager == null) {
            throw new IllegalStateException("semanticsManager\u5fc5\u987b\u8bbe\u7f6e");
        }
    }
}

