package com.walker.web.security;

import com.walker.web.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;
import java.util.Iterator;

/**
 * 请求拦截确定管理器-自定义实现</p>
 * 根据请求的URL查找具有的合法角色集合，如果未找到抛出异常。
 * @author shikeying
 * @throws AccessDeniedException
 *
 */
public class DefaultAccessDecisionManager implements AccessDecisionManager {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

//    private List<String> anonymousUrlList = null;
//
//    /**
//     * 设置可匿名访问的公开地址集合，如: ["/login","/register", ""]
//     * @param anonymousUrlList
//     */
//    public void setAnonymousUrlList(List<String> anonymousUrlList) {
//        this.anonymousUrlList = anonymousUrlList;
//    }

    @Override
    public void decide(Authentication authentication, Object url,
                       Collection<ConfigAttribute> configAttributes) throws AccessDeniedException,
            InsufficientAuthenticationException {
        if(configAttributes == null)
            return;
//		logger.debug("......拦截的url: " + url);
        logger.debug("configAttributes = {}", configAttributes);
        Iterator<ConfigAttribute> ite=configAttributes.iterator();
        ConfigAttribute ca = null;
        String needRole = null;
        while(ite.hasNext()){
            ca = ite.next();
            needRole = ((SecurityConfig)ca).getAttribute();
            logger.debug(".............. needRole = {}", needRole);
            if(needRole.equals(Constants.ROLE_ANONYMOUS)){
                logger.debug("匿名URL,不拦截:" + url);
                return;
            }
            if(needRole.equals(Constants.ROLE_ACTIVITI_USER)){
                logger.debug("Activiti7(/wf/**) URL,不拦截:" + url);
                return;
            }
            for(GrantedAuthority ga : authentication.getAuthorities()){
                logger.debug("/////// ga = {}", ga.getAuthority());
                if(needRole.equals(ga.getAuthority())){
                    logger.debug("......找到了匹配的角色: " + needRole);
                    return;
                }
            }
        }
        logger.debug("xxxxxxxxxxxxx 未找到匹配角色，needRole = " + needRole + ", url = " + url);
        throw new AccessDeniedException("you can't access this resource: " + url);
    }

    @Override
    public boolean supports(ConfigAttribute arg0) {
        return true;
    }

    @Override
    public boolean supports(Class<?> arg0) {
        return true;
    }
}
