package com.walker.web.security;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.web.ResponseCode;
import com.walker.web.ResponseValue;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

import java.io.IOException;

/**
 * 认证过的用户访问无权限资源时的处理器.
 * @author 时克英
 * @date 2022-11-01
 */
public class DefaultAccessDeniedHandler implements AccessDeniedHandler {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        String msg = "已认证,但未分配系统权限:" + request.getRequestURI();
        try {
            ServletUtils.renderString(response, JsonUtils.objectToJsonString(ResponseValue.error(ResponseCode.EXCEPTION.getCode(), msg)));
        } catch (Exception e) {
            logger.error("未分配系统权限:" + request.getRequestURI());
        }
    }
}
