package com.walker.web.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

import java.util.Collection;

/**
 * 请求资源过滤拦截元数据提供者，该对象会再用户每次请求时根据URL组装返回对应的角色集合，
 * 以供框架判断是否能够访问。</p>
 * 该对象替换老版本中的<code>MySecurityMetadataSource</code>
 *
 * @author 时克英
 * @date 2018-10-16
 * @since 0.6.0
 *
 */
public class DefaultSecurityMetadataSource implements FilterInvocationSecurityMetadataSource {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    private ResourceLoadProvider resourceLoaderProvider;

    public void setResourceLoaderProvider(ResourceLoadProvider resourceLoaderProvider) {
        if(resourceLoaderProvider == null){
            throw new IllegalArgumentException("resourceLoaderProvider is required!");
        }
        this.resourceLoaderProvider = resourceLoaderProvider;
        logger.info("===========开始初始化resourceLoaderProvider.loadResource();");
//		this.resourceLoaderProvider.loadResource();
    }

    @Override
    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    @Override
    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        return this.resourceLoaderProvider.getAttributes(object);
    }

    @Override
    public boolean supports(Class<?> arg0) {
        return true;
    }

    public synchronized void reloadResource(){
        this.resourceLoaderProvider.reloadResource();
        logger.info("resourceLoaderProvider重新加载完毕!");
    }
}
