package com.walker.web.security;

import java.util.Collection;
import java.util.Map;

import org.springframework.security.access.ConfigAttribute;

/**
 * 角色与资源加载器定义</p>
 * 它主要实现从业务系统中加载系统可用的链接地址与角色的对应关系。</br>
 * 注意：这些URL通常是应该被保护的，例如：功能URL、按钮URL等。
 * @author shikeying
 *
 */
public interface ResourceLoadProvider {

	/**
	 * 加载资源URL与角色对应数据
	 * @return key=url, value=角色集合，ConfigAttribute是spring security定义的对象。
	 */
	Map<String, Collection<ConfigAttribute>> loadResource();

	/**
	 * 重新加载资源权限，用于动态更新，通常是用户角色更新权限使用。
	 * @date 2022-11-01
	 */
	void reloadResource();
	
	Collection<ConfigAttribute> getAttributes(Object object);
	
	/**
	 * 根据用户访问的URI找出系统匹配定义的权限URI信息。</p>
	 * 该方法在shiro中使用，但springSecurity也可用，不过还没替换掉。
	 * @param uri 如：/admin/file/index.do，注意此处uri是不带contextPath的!
	 * @return spring的对象<code>ConfigAttribute</code>集合
	 */
	Collection<ConfigAttribute> getAttributesByUri(String uri);
}
