package com.walker.web.security;

import com.walker.web.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * 由于集成 Activiti7 总是被请求拦截报错（：不能访问），所以重写该对象尝试替换现有。
 * @author 时克英
 * @date 2023-03-21
 */
@Deprecated
public class SimpleAccessDecisionManager extends AbstractAccessDecisionManager {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    protected SimpleAccessDecisionManager(List<AccessDecisionVoter<?>> decisionVoters) {
        super(decisionVoters);
    }

    @Override
    public void decide(Authentication authentication
            , Object url, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        if(configAttributes == null)
            return;
//		logger.debug("......拦截的url: " + url);
        Iterator<ConfigAttribute> ite=configAttributes.iterator();
        ConfigAttribute ca = null;
        String needRole = null;
        while(ite.hasNext()){
            ca = ite.next();
            needRole = ((SecurityConfig)ca).getAttribute();
            if(needRole.equals(Constants.ROLE_ANONYMOUS)){
                logger.debug("匿名URL,不拦截:" + url);
                return;
            }
            if(needRole.equals(Constants.ROLE_ACTIVITI_USER)){
                logger.debug("Activiti7(/wf/**) URL,不拦截:" + url);
                return;
            }
            for(GrantedAuthority ga : authentication.getAuthorities()){
                if(needRole.equals(ga.getAuthority())){
                    logger.debug("......找到了匹配的角色: " + needRole);
                    return;
                }
            }
        }
        logger.debug("-----------> 未找到匹配角色，needRole = " + needRole + ", url = " + url);
        throw new AccessDeniedException("you can't access this resource: " + url);
    }
}
