package com.walker.web;

/**
 * 验证码类型定义。
 * @author 时克英
 * @date 2023-03-13
 */
public enum CaptchaType {

    /**
     * 普通输入验证码：数字、公式、计算结果等
     */
    InputCode {
        public String getIndex(){
            return INDEX_INPUT_CODE;
        }
    },

    /**
     * 短信验证码
     */
    SmsCode {
        public String getIndex(){
            return INDEX_SMS_CODE;
        }
    },

    /**
     * 纯滑块验证
     */
    Slide {
        public String getIndex(){
            return INDEX_SLIDE;
        }
    },

    /**
     * 拼图验证
     */
    Jigsaw {
        public String getIndex(){
            return INDEX_JIGSAW;
        }
    },

    /**
     * 新的拼图验证组件，效果更好，更适合移动端使用。PC端同样能用，电商模块添加。
     * @date 2023-06-27
     */
    JigsawMobile {
        public String getIndex(){
            return INDEX_JIGSAW_MOBILE;
        }
    },

    /**
     * 空验证码类型，没有使用验证码。
     * @date 2023-03-20
     */
    None {
        public String getIndex(){
            return INDEX_NONE;
        }
    },

    /**
     * 第三方登录对接验证方式（目前对接为预算一体化，其他后面遇到再看情况）。
     * @date 2023-07-03
     */
    ThirdParty {
        public String getIndex(){
            return INDEX_THIRD_PARTY;
        }
    };

    public String getIndex(){
        throw new AbstractMethodError();
    }

    public static final CaptchaType getType(String index){
        if(index.equalsIgnoreCase(INDEX_INPUT_CODE)){
            return InputCode;
        } else if(index.equalsIgnoreCase(INDEX_SMS_CODE)){
            return SmsCode;
        } else if(index.equalsIgnoreCase(INDEX_SLIDE)){
            return Slide;
        } else if(index.equalsIgnoreCase(INDEX_JIGSAW)){
            return Jigsaw;
        } else if(index.equalsIgnoreCase(INDEX_JIGSAW_MOBILE)){
            return JigsawMobile;
        } else if(index.equalsIgnoreCase(INDEX_NONE)){
            return None;
        } else if(index.equalsIgnoreCase(INDEX_THIRD_PARTY)){
            return ThirdParty;
        } else {
            throw new UnsupportedOperationException("不支持的验证码类型:" + index);
        }
    }

    public static final String INDEX_INPUT_CODE = "code";
    public static final String INDEX_SMS_CODE = "sms";
    public static final String INDEX_SLIDE = "slide";
    public static final String INDEX_JIGSAW = "jigsaw";
    public static final String INDEX_JIGSAW_MOBILE = "jigsaw_mobile";
    public static final String INDEX_NONE = "none";

    public static final String INDEX_THIRD_PARTY = "third_party";
}
