package com.walker.web;

/**
 * 终端(设备)类型，用于确定用户使用哪种设备使用(登录)系统。
 * <p></p>
 * 该定义和 {@linkplain LoginType} 是有区别的，LoginType表示登录要采用哪种方式验证。
 * @author 时克英
 * @date 2023-01-28
 */
public enum ClientType {

    PC{
        public String getIndex(){
            return INDEX_PC;
        }
    },

    /**
     * 手机等移动端设备
     */
    MOBILE{
        public String getIndex(){
            return INDEX_MOBILE;
        }
    },

    TV {
        public String getIndex(){
            return INDEX_TV;
        }
    },

    /**
     * 其他智能设备，不太确认的。
     */
    OTHER{
        public String getIndex(){
            return INDEX_OTHER;
        }
    };

    public String getIndex(){
        throw new AbstractMethodError();
    }

    public static final ClientType getType(String index){
        if(index.equals(INDEX_PC)){
            return PC;
        } else if(index.equals(INDEX_MOBILE)){
            return MOBILE;
        } else if(index.equals(INDEX_TV)){
            return TV;
        } else if(index.equals(INDEX_OTHER)){
            return OTHER;
        } else {
            throw new UnsupportedOperationException("不支持的终端类型:" + index);
        }
    }

    public static final String INDEX_PC = "pc";
    public static final String INDEX_MOBILE = "mobile";
    public static final String INDEX_TV = "tv";
    public static final String INDEX_OTHER = "other";
}
