package com.walker.web;

/**
 * 数据状态枚举类型
 * @author 时克英
 * @date 2018-11-29
 *
 */
public enum DataStatus {

	/**
	 * 正常状态数据：1
	 */
	Normal{
		public int getTypeValue(){
			return CONST_NORMAL;
		}
	},
	
	/**
	 * 禁用状态数据：0
	 */
	Disable{
		public int getTypeValue(){
			return CONST_DISABLE;
		}
	},
	
	/**
	 * 删除状态数据：-1
	 */
	Deleted {
		public int getTypeValue(){
			return CONST_DELETED;
		}
	};
	
	public static final int CONST_NORMAL = 0;
	public static final int CONST_DISABLE = 1;
	public static final int CONST_DELETED = 2;
	
	/**
	 * 返回枚举类型值
	 * @return
	 */
	public int getTypeValue(){
		throw new AbstractMethodError();
	}
	
	public static DataStatus getType(int index){
		if(index == CONST_NORMAL){
			return Normal;
		} else if(index == CONST_DISABLE){
			return Disable;
		} else if(index == CONST_DELETED){
			return Deleted;
		} else
			throw new IllegalArgumentException("unsupported DataStatus: " + index);
	}
	
}
