package com.walker.web;

/**
 * 登录类型定义，前端可通过多种方式登录，并同时支持多种方式同时登录，如：PC端和APP端。
 * @date 2023-01-28 重新定义该对象含义，表示登录时使用哪种方式验证用户，如:
 * <pre>
 *     1) 用户名、密码
 *     2) 手机号、短信验证码
 *     3) 微信登第三方绑定登录验证
 * </pre>
 */
public enum LoginType {

    /**
     * 用户名密码登录。
     * @date 2023-03-20 该类型转为PC端登录类型。
     */
    UserPassword{
        public String getIndex(){
            return INDEX_USER_PASSWORD;
        }
    },

    /**
     * 短信验证码登录
     */
    SmsCode{
        public String getIndex(){
            return INDEX_SMS_CODE;
        }
    },

    Wechat{
        public String getIndex(){
            return INDEX_WECHAT;
        }
    },

    DingTalk{
        public String getIndex(){
            return INDEX_DING_TALK;
        }
    },

    /**
     * 专门针对移动端的账号、密码登录（没有验证码）
     * @date 2023-03-20
     */
    MobilePassword {
        public String getIndex(){
            return INDEX_MOBILE_PASSWORD;
        }
    },

    ThirdParty {
        public String getIndex(){
            return INDEX_THIRD_PARTY;
        }
    };

    public String getIndex(){
        throw new AbstractMethodError();
    }

    public static final LoginType getType(String index){
        if(index.equals(INDEX_USER_PASSWORD)){
            return UserPassword;
        } else if(index.equals(INDEX_SMS_CODE)){
            return SmsCode;
        } else if(index.equals(INDEX_WECHAT)){
            return Wechat;
        } else if(index.equals(INDEX_DING_TALK)){
            return DingTalk;
        } else if(index.equals(INDEX_MOBILE_PASSWORD)){
            return MobilePassword;
        } else if(index.equals(INDEX_THIRD_PARTY)){
            return ThirdParty;
        } else {
            throw new IllegalArgumentException("不支持的登录类型:" + index);
        }
    }

    public static final String INDEX_USER_PASSWORD = "user_pass";
    public static final String INDEX_SMS_CODE = "sms_code";
    public static final String INDEX_WECHAT = "wechat";
    public static final String INDEX_DING_TALK = "ding_talk";
    public static final String INDEX_MOBILE_PASSWORD = "mobile_pass";

    public static final String INDEX_THIRD_PARTY = "third_party";
}
