package com.walker.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Token生成器定义。
 * @author 时克英
 * @date 2022-10-10
 */
public interface TokenGenerator {

    public final Logger logger = LoggerFactory.getLogger(TokenGenerator.class);

    public final static String NAME_OWNER = "walkersoft";

    /**
     * 存放用户缓存的键值名称, 会在token中储存对应的UUID。
     * @date 2022-11-01
     */
    public static final String NAME_lOGIN_USER_KEY = "login_user_key";
    public static final String NAME_USER_ID_KEY = "user_id_key";

    /**
     * 创建Token
     * @param claims 业务参数
     * @param expiredMinutes 失效分钟数
     * @param secretKey 密钥字符串，如果为空则通过方法 {@linkplain TokenGenerator#acquireSecretKey()} 获取
     * @return
     */
    String createToken(String claims, long expiredMinutes, String secretKey);

    /**
     * 创建Token
     * @param userKey 要放入缓存的key
     * @param userId 用户ID
     * @param expiredMinutes 失效分钟数
     * @param magicKey 密钥字符串，如果为空则通过方法 {@linkplain TokenGenerator#acquireSecretKey()} 获取
     * @return userId,loginUserKey(UUID)
     */
    String createToken(String userKey, String userId, long expiredMinutes, String magicKey);

    /**
     * 验证Token，并返回业务参数
     * @param token
     * @param secretKey 密钥字符串，如果为空则通过方法 {@linkplain TokenGenerator#acquireSecretKey()} 获取
     * @return 返回创建是写入的业务数据: userId,userKey
     * @throws TokenException 验证失败抛出异常
     */
    String validateToken(String token, String secretKey) throws TokenException;

    /**
     * 获取签名密钥
     * @return
     */
    String acquireSecretKey();
}
