package com.walker.web;

public enum UserType {

	/**
	 * 超级管理员
	 */
	SuperVisor{
		public int getTypeValue(){
			return TYPE_SUPER;
		}
	},

	/**
	 * 独立单位管理员，必须在单位下面，不能在部门下面
	 */
	Administrator{
		public int getTypeValue(){
			return TYPE_ADMIN;
		}
	},

	/**
	 * 独立单位内部部门管理，不能在单位下，只能在部门下面
	 */
	AdministratorDept{
		public int getTypeValue(){
			return TYPE_ADMIN_DEPT;
		}
	},

	/**
	 * 普通用户
	 */
	User{
		public int getTypeValue(){
			return TYPE_NORMAL;
		}
	},

	UserApp{
		public int getTypeValue(){
			return TYPE_APP_REG;
		}
	},

	/**
	 * 非用户，一些设备需要获得系统连接授权的情况。
	 * @date 2022-11-06
	 */
	UserEquipment{
		public int getTypeValue(){
			return TYPE_EQUIPMENT;
		}
	},

	/**
	 * 商户店长
	 */
	SUPER_MERCHANT {
		public int getTypeValue(){
			return TYPE_SUPER_MERCHANT;
		}
	},

	/**
	 * 商户管理员
	 */
	MERCHANT_ADMIN {
		public int getTypeValue(){
			return TYPE_MERCHANT_ADMIN;
		}
	}
	;

	public static final UserType getType(int index){
		if(index == TYPE_SUPER){
			return SuperVisor;
		} else if(index == TYPE_ADMIN){
			return Administrator;
		} else if(index == TYPE_ADMIN_DEPT){
			return AdministratorDept;
		} else if(index == TYPE_NORMAL){
			return User;
		} else if(index == TYPE_APP_REG){
			return UserApp;
		} else if(index == TYPE_EQUIPMENT){
			return UserEquipment;
		} else if(index == TYPE_SUPER_MERCHANT){
			return SUPER_MERCHANT;
		} else if(index == TYPE_MERCHANT_ADMIN){
			return MERCHANT_ADMIN;
		}  else {
			throw new UnsupportedOperationException("不支持的用户类型:" + index);
		}
	}

	public static final int TYPE_SUPER = 0;
	public static final int TYPE_ADMIN = 1;		// 独立单位管理员，必须在单位下面，不能在部门下面
	public static final int TYPE_ADMIN_DEPT = 3;// 独立单位内部部门管理，不能在单位下，只能在部门下面
	public static final int TYPE_NORMAL = 2;
	public static final int TYPE_APP_REG = 99;
	public static final int TYPE_EQUIPMENT = 100;

	// 2023-05-15
	public static final int TYPE_SUPER_MERCHANT = 5;	// 商户店长
	public static final int TYPE_MERCHANT_ADMIN = 6;	// 商户管理员

	/**
	 * 返回用户类型值
	 * @return
	 */
	public int getTypeValue(){
		throw new AbstractMethodError();
	}
}
