package com.walker.web;

import com.walker.infrastructure.ApplicationRuntimeException;

/**
 * WEB 层面抛出的业务异常定义，框架会整体在 <code>RestController</code> 中拦截并返回响应。
 * @author 时克英
 * @date 2022-10-12
 */
public class WebRuntimeException extends ApplicationRuntimeException {

    private int code = ResponseValue.CODE_ERROR;
    private String msg;

    private String data;

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getData() {
        return data;
    }

    public WebRuntimeException(String msg){
        super(msg);
        this.msg = msg;
    }

    public WebRuntimeException(String msg, Throwable cause){
        super(msg, cause);
        this.msg = msg;
    }

    public WebRuntimeException(int code, String msg, String data){
        super(msg);
        this.code = code;
        this.msg = msg;
        this.data = data;
    }
    public WebRuntimeException(String msg, String data){
        super(msg);
        this.msg = msg;
        this.data = data;
    }
}
