package com.walker.web.interceptor;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.web.ResponseValue;
import com.walker.web.annotation.RepeatSubmit;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import java.lang.reflect.Method;

/**
 * 重复提交拦截器，暂时没有添加实现类，可参考若依代码。
 * @author 时克英
 * @date 2022-10-10
 */
public abstract class RepeatSubmitInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod)
        {
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            Method method = handlerMethod.getMethod();
            RepeatSubmit annotation = method.getAnnotation(RepeatSubmit.class);
            if (annotation != null)
            {
                if (this.isRepeatSubmit(request, annotation)) {
//                    AjaxResult ajaxResult = AjaxResult.error(annotation.message());
//                    ServletUtils.renderString(response, JSON.toJSONString(ajaxResult));
                    ResponseValue<String> rv = ResponseValue.success(annotation.message());
                    ServletUtils.renderString(response, JsonUtils.objectToJsonString(rv));
                    return false;
                }
            }
            return true;
        }
        else {
            return true;
        }
    }

    /**
     * 验证是否重复提交由子类实现具体的防重复提交的规则
     *
     * @param request
     * @return
     * @throws Exception
     */
    public abstract boolean isRepeatSubmit(HttpServletRequest request, RepeatSubmit annotation);
}
