package com.walker.web.log;

public enum BusinessType {

    Insert{
        public int getIndex(){
            return INDEX_INSERT;
        }
        public String getName(){
            return NAME_INSERT;
        }
        public boolean isSaveRequest(){
            return true;
        }
        public boolean isSaveResponse(){
            return true;
        }
    },
    Update{
        public int getIndex(){
            return INDEX_UPDATE;
        }
        public String getName(){
            return NAME_UPDATE;
        }
        public boolean isSaveRequest(){
            return true;
        }
        public boolean isSaveResponse(){
            return true;
        }
    },
    Delete{
        public int getIndex(){
            return INDEX_DELETE;
        }
        public String getName(){
            return NAME_DELETE;
        }
        public boolean isSaveRequest(){
            return true;
        }
        public boolean isSaveResponse(){
            return true;
        }
    },
    Search{
        public int getIndex(){
            return INDEX_SEARCH;
        }
        public String getName(){
            return NAME_SEARCH;
        }
        public boolean isSaveRequest(){
            return true;
        }
        public boolean isSaveResponse(){
            return false;
        }
    },
    GetData{
        public int getIndex(){
            return INDEX_GET_DATA;
        }
        public String getName(){
            return NAME_GET_DATA;
        }
        public boolean isSaveRequest(){
            return true;
        }
        public boolean isSaveResponse(){
            return true;
        }
    },
    Import{
        public int getIndex(){
            return INDEX_IMPORT;
        }
        public String getName(){
            return NAME_IMPORT;
        }
        public boolean isSaveRequest(){
            return false;
        }
        public boolean isSaveResponse(){
            return true;
        }
    },
    Export{
        public int getIndex(){
            return INDEX_EXPORT;
        }
        public String getName(){
            return NAME_EXPORT;
        }
        public boolean isSaveRequest(){
            return true;
        }
        public boolean isSaveResponse(){
            return false;
        }
    },
    DownloadFile{
        public int getIndex(){
            return INDEX_DOWNLOAD_FILE;
        }
        public String getName(){
            return NAME_DOWNLOAD_FILE;
        }
        public boolean isSaveRequest(){
            return true;
        }
        public boolean isSaveResponse(){
            return false;
        }
    },
    UploadFile{
        public int getIndex(){
            return INDEX_UPLOAD_FILE;
        }
        public String getName(){
            return NAME_UPLOAD_FILE;
        }
        public boolean isSaveRequest(){
            return false;
        }
        public boolean isSaveResponse(){
            return true;
        }
    },
    Other{
        public int getIndex(){
            return INDEX_OTHER;
        }
        public String getName(){
            return NAME_OTHER;
        }
        public boolean isSaveRequest(){
            return true;
        }
        public boolean isSaveResponse(){
            return true;
        }
    };

    public int getIndex(){
        throw new AbstractMethodError();
    }

    public String getName(){
        throw new AbstractMethodError();
    }

    public boolean isSaveRequest(){
        throw new AbstractMethodError();
    }
    public boolean isSaveResponse(){
        throw new AbstractMethodError();
    }

    public static final String NAME_INSERT = "新增";
    public static final String NAME_UPDATE = "更新";
    public static final String NAME_DELETE = "删除";
    public static final String NAME_SEARCH = "检索";
    public static final String NAME_GET_DATA = "获取数据";
    public static final String NAME_IMPORT = "导入";
    public static final String NAME_EXPORT = "导出";
    public static final String NAME_DOWNLOAD_FILE = "下载文件";
    public static final String NAME_UPLOAD_FILE = "上传文件";
    public static final String NAME_OTHER = "其他";

    public static final int INDEX_INSERT = 1;
    public static final int INDEX_UPDATE = 2;
    public static final int INDEX_DELETE = 3;
    public static final int INDEX_SEARCH = 4;
    public static final int INDEX_GET_DATA = 5;
    public static final int INDEX_IMPORT = 6;
    public static final int INDEX_EXPORT = 7;
    public static final int INDEX_DOWNLOAD_FILE = 8;
    public static final int INDEX_UPLOAD_FILE = 9;
    public static final int INDEX_OTHER = 0;
}
