package com.walker.web.log;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 操作日志注解定义。
 * @date 2023-01-06
 */
@Target({ ElementType.PARAMETER, ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Log {

    /**
     * 模块 或 功能名称
     */
    public String title() default "";

    /**
     * 业务类型 <p></p>
     * <pre>
     *     1)当业务类型里面定义的不保存数据时，优先使用这里的配置。
     *     2)isSaveRequest(), isSaveResponse()
     * </pre>
     */
    public BusinessType businessType() default BusinessType.Other;

    /**
     * 操作人类别
     */
    public OperateUser operatorType() default OperateUser.Manage;

    /**
     * 是否保存请求的参数
     */
    public boolean isSaveRequestData() default true;

    /**
     * 是否保存响应的参数
     */
    public boolean isSaveResponseData() default true;

}
