package com.walker.web.token;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.TokenException;
import com.walker.web.TokenGenerator;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JwtTokenGenerator implements TokenGenerator {

    private static final long ONE_MINUTE_MILLS = 1 * 60 * 1000;

    @Override
    public String createToken(String userId, long expiredMinutes, String magicKey) {
//        if(StringUtils.isEmpty(claims)){
//            throw new IllegalArgumentException("createToken error: claims is required!");
//        }
//
//        JwtBuilder builder = Jwts.builder().setIssuer(NAME_OWNER)
//                .setIssuedAt(new Date())
//                .setSubject(claims)
//                .signWith(SignatureAlgorithm.HS512, magicKey);
//
//        long expiredTime = 0;
//        if(expiredMinutes > 0){
//            expiredTime = System.currentTimeMillis() + expiredMinutes * ONE_MINUTE_MILLS;
//            builder.setExpiration(new Date(expiredTime));
//            logger.debug("token 过期时间:" + expiredTime);
//        }
//        return builder.compact();
        return this.createToken(null, userId, expiredMinutes, magicKey);
    }

    @Override
    public String createToken(String userKey, String userId, long expiredMinutes, String magicKey){
        if(StringUtils.isEmpty(userId)){
            throw new IllegalArgumentException("createToken error: userId is required!");
        }

        JwtBuilder builder = Jwts.builder().setIssuer(NAME_OWNER)
                .setIssuedAt(new Date());
//                .setSubject(userId);
        // 如果存在，设置用户缓存唯一标识(UUID),2022-11-01
        Map<String, Object> claims = new HashMap<>(2);
        if(StringUtils.isNotEmpty(userKey)){
            claims.put(NAME_lOGIN_USER_KEY, userKey);
            claims.put(NAME_USER_ID_KEY, userId);
        } else {
            claims.put(NAME_USER_ID_KEY, userId);
        }
        builder.addClaims(claims);
        builder.signWith(SignatureAlgorithm.HS512, magicKey);

        long expiredTime = 0;
        if(expiredMinutes > 0){
            expiredTime = System.currentTimeMillis() + expiredMinutes * ONE_MINUTE_MILLS;
            builder.setExpiration(new Date(expiredTime));
            logger.debug("token 过期时间:" + expiredTime);
        }
        return builder.compact();
    }

    @Override
    public String validateToken(String token, String secretKey) throws TokenException {
        try{
            Claims c = Jwts.parser().setSigningKey(secretKey).parseClaimsJws(token).getBody();
            if(c == null){
                throw new TokenException("token claims is null!");
            }
            StringBuilder sb = new StringBuilder(c.get(NAME_USER_ID_KEY).toString());
            if(c.get(NAME_lOGIN_USER_KEY) != null){
                sb.append(StringUtils.DEFAULT_SPLIT_SEPARATOR);
                sb.append(c.get(NAME_lOGIN_USER_KEY).toString());
            }
            return sb.toString();
//            return c.getSubject();
        } catch (Exception ex){
            if(ex instanceof SignatureException){
                throw new TokenException("token签名解析错误", ex);
            } else if(ex instanceof ExpiredJwtException){
                throw new TokenException("token过期", ex, true);
            } else {
                throw new TokenException(ex.getMessage(), ex);
            }
        }
    }

//    public String getDataFromToken(String token, String secretKey){
//        try{
//            Claims c = Jwts.parser().setSigningKey(secretKey).parseClaimsJws(token).getBody();
//            if(c == null){
////                throw new TokenException("token claims is null!");
//                System.out.println("解析token业务数据时，返回null");
//                return null;
//            }
//        } catch (Exception ex){
//        }
//    }

    @Override
    public String acquireSecretKey() {
        return null;
    }

//    private String getData(Claims c){
//        StringBuilder sb = new StringBuilder(c.get(NAME_USER_ID_KEY).toString());
//        if(c.get(NAME_lOGIN_USER_KEY) != null){
//            sb.append(StringUtils.DEFAULT_SPLIT_SEPARATOR);
//            sb.append(c.get(NAME_lOGIN_USER_KEY).toString());
//        }
//        return sb.toString();
//    }
}
