package com.walker.web.util;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.io.IOException;

/**
 * 与Servlet有关的工具类，后续迁移到Spring Boot 3.0 后，很可能废弃Servlet机制。
 * @date 2022-11-06
 */
public class ServletUtils {

    /**
     * 通过上下文获取请求对象。
     * @return
     * @date 2023-01-06
     */
    public static HttpServletRequest getRequest(){
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes.getRequest();
    }

    public static HttpServletResponse getResponse(){
//		return RequestAwareContext.getCurrentResponse();
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    /**
     * 返回服务端调用地址前缀，如:<br>
     * http://localhost:8080/demo
     * @param request
     * @return
     * @date 2023-01-06
     */
    public static String getServerDomain(HttpServletRequest request){
        StringBuffer url = request.getRequestURL();
        String contextPath = request.getServletContext().getContextPath();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).append(contextPath).toString();
    }

    /**
     * 将字符串渲染到客户端
     *
     * @param response 渲染对象
     * @param string 待渲染的字符串
     */
    public static void renderString(HttpServletResponse response, String string) {
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            response.setCharacterEncoding(StringUtils.DEFAULT_CHARSET_UTF8);
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 把对象转成json字符串渲染到客户端
     * @param response
     * @param rv
     * @date 2022-11-02
     */
    public static void renderString(HttpServletResponse response, ResponseValue<?> rv){
        try {
            String json = JsonUtils.objectToJsonString(rv);
            renderString(response, json);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
