package com.walker.web;

/**
 * 验证码生成提供者，可实现多种验证码方式，如：字符、计算式、滑块等。
 * @param <T> 验证码返回类型。
 * @author 时克英
 * @date 2022-11-06
 */
public interface CaptchaProvider<T> {

    /**
     * 生成验证码对象，由实现者定义。
     * @param param 输入参数，暂时未使用
     * @return
     */
    T generateCaptcha(Object param);

    /**
     * 验证已生成的码是否正确
     * @param data
     * @return
     */
    boolean validateCaptcha(T data);

    /**
     * 返回验证码定义类型。
     * @return
     * @date 2023-03-14
     */
    CaptchaType getCaptchaType();
}
