package com.walker.web;

/**
 * 描述：
 * @author 时克英
 * @date 2020年6月29日 下午1:49:53
 */

public class Constants {

	public static final String API_PREFIX = "/api";

	public static final String TIP_TOKEN_FAILED = "authority not found!";

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	//~ token 相关，2022-10-12
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	public static final String TOKEN_NAME = "token";

	/**
	 * 令牌前缀
	 */
	public static final String TOKEN_PREFIX = "Bearer ";

	public static final String TOKEN_HEADER = "Authorization";

	/**
	 * 刷新token，header属性名称
	 * @date 2022-11-13
	 */
	public static final String TOKEN_HEADER_REFRESH = "TokenRefresh";

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	//~ WEB 相关，2022-10-12
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	public static final String APPLICATION_JSON = "application/json;charset=UTF-8";
	public static final String APPLICATION_XML = "application/xml;charset=UTF-8";
	public static final String APPLICATION_WWW = "application/x-www-form-urlencoded";
	public static final String TEXT_XML = "text/xml;charset=UTF-8";
	public static final String TEXT_PLAIN = "text/plain;charset=UTF-8";
	public static final String FILE_APK = "application/vnd.android.package-archive";

	public static final int HTTP_SUCCESS = 200;

	public static final String HTTP_METHOD_GET = "GET";
	public static final String HTTP_METHOD_POST = "POST";
	public static final String HTTP_METHOD_PUT = "PUT";
	public static final String HTTP_METHOD_DELETE = "DELETE";

	/**
	 * 中文GBK字符串常量。
	 * @date 2023-01-05
	 */
	public static final String CHARSET_GBK = "GBK";

	/**
	 * 拦截包含: /list 等请求，加入分页信息，即:自动执行 this.preparePageSearch();
	 * @date 2023-01-28
	 */
	public static final String KEY_INTERCEPTOR_PAGE_LIST = "/list";

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	//~ WEB SECURITY 相关，2022-11-03
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * 匿名角色，遇到后系统自动放过。
	 * @date 2022-11-03
	 */
	public static final String ROLE_ANONYMOUS = "ROLE_ANONYMOUS";

	/**
	 * 空角色，意味着没有匹配到任何角色(没有权限)。
	 * @date 2022-11-13
	 */
	public static final String ROLE_EMPTY = "ROLE_EMPTY";

	/**
	 * activiti7工作流强制使用的角色
	 * @date 2023-03-21
	 */
	public static final String ROLE_ACTIVITI_USER = "ROLE_ACTIVITI_USER";

}
