package com.walker.web;

public enum OrgType {

	/**
	 * 机构类型：独立单位(如:集团)
	 */
	Org{
		public int getTypeValue(){
			return TYPE_ORG;
		}
	},
	
	/**
	 * 子单位，即：独立单位下面的单位（从属）(如:分公司)
	 */
	OrgSub{
		public int getTypeValue(){
			return TYPE_ORG_SUB;
		}
	},

	/**
	 * 分公司下的厂区。(如:工厂)
	 * @date 2022-11-06
	 */
	OrgFactory{
		public int getTypeValue(){
			return TYPE_ORG_FACTORY;
		}
	},

	/**
	 * 厂区下分厂
	 */
	OrgSubFactory{
		public int getTypeValue(){
			return TYPE_ORG_FACTORY_SUB;
		}
	},

	/**
	 * 机构类型：部门，可以在任何机构节点下，即：任何单位分厂都会有部门。
	 */
	Dept{
		public int getTypeValue(){
			return TYPE_DEPT;
		}
	},
	
	/**
	 * 机构类型：所有，部门 + 单位
	 */
	All{
		public int getTypeValue(){
			return TYPE_ALL;
		}
	};

	public static final OrgType getType(int index){
		if(index == 0){
			return Org;
		} else if(index == 1){
			return OrgSub;
		} else if(index == 2){
			return OrgFactory;
		} else if(index == 3){
			return OrgSubFactory;
		} else if(index == 9){
			return Dept;
		} else if(index == 10){
			return All;
		} else {
			throw new UnsupportedOperationException("未知机构类型:" + index);
		}
	}

	public static final int TYPE_ORG = 0;	// 独立单位，例如：集团
	public static final int TYPE_ORG_SUB = 1; // 子单位，即：独立单位下面的单位，如：分公司
	public static final int TYPE_ORG_FACTORY = 2; // 分公司下面的厂
	public static final int TYPE_ORG_FACTORY_SUB = 3; // 分公司下面的厂
	public static final int TYPE_DEPT = 9;	// 部门信息，可以挂在单位、分公司或厂下面
	public static final int TYPE_ALL = 10;
	
	/**
	 * 返回机构类型值
	 * @return
	 */
	public int getTypeValue(){
		throw new AbstractMethodError();
	}
}
