package com.walker.web;

import java.io.Serializable;
import java.util.List;

/**
 * 描述：响应web请求对象定义。
 * @author 时克英
 * @date 2020年6月30日 上午10:42:18
 */

public class ResponseValue<T> implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3530568444640938940L;
	
	public static final int CODE_SUCCESS = ResponseCode.SUCCESS.getCode();
	public static final int CODE_ERROR = ResponseCode.ERROR.getCode();
	public static final int CODE_EXCEPTION = ResponseCode.EXCEPTION.getCode();
	public static final int CODE_RELOGIN = 10;
	public static final String TEXT_SUCCESS = "success";
    public static final String TEXT_ERROR = "failed";
    public static final String TEXT_RELOGIN = "超时，请重新登录";
	
	private boolean state = false;
	private int code = CODE_ERROR;
	private String msg;
	private T data = null;

	// 为适配若依前端增加属性，2022-10-10
	private long total = 0;
	
//	private List<T> datas = null;
//	public List<T> getDatas() {
//		return datas;
//	}
//	public void setDatas(List<T> datas) {
//		this.datas = datas;
//	}

	private ResponseValue(){}
	
	public boolean isState() {
		if(code == CODE_SUCCESS){
			return true;
		}
		return state;
	}
	public void setState(boolean state) {
		this.state = state;
	}
	public int getCode() {
		return code;
	}
	public void setCode(int code) {
		this.code = code;
	}
	public String getMsg() {
		return this.msg;
	}
	public void setMsg(String text) {
		this.msg = text;
	}
	public T getData() {
		return data;
	}
	public void setData(T data) {
		if(data == null){
			return;
		}
		if(data instanceof List){
			List<?> list = (List<?>)data;
			this.total = list.size();
		}
		this.data = data;
	}

	public long getTotal() {
		return total;
	}
	public void setTotal(long total) {
		this.total = total;
	}
	
	public static <T> ResponseValue<T> success(T data){
		return success(TEXT_SUCCESS, data);
	}
	
	public static <T> ResponseValue<T> success(String text, T data){
		ResponseValue<T> rv = new ResponseValue<T>();
		rv.setState(true);
		rv.setCode(CODE_SUCCESS);
		rv.setMsg(text);
		rv.setData(data);
		return rv;
	}
	
	public static ResponseValue<List<?>> success(String text, List<?> data){
		ResponseValue<List<?>> rv = new ResponseValue<List<?>>();
		rv.setState(true);
		rv.setCode(CODE_SUCCESS);
		rv.setMsg(text);
		rv.setData(data);
		return rv;
	}
	
	public static ResponseValue<String> success(String text){
		ResponseValue<String> rv = new ResponseValue<String>();
		rv.setState(true);
		rv.setCode(CODE_SUCCESS);
		rv.setMsg(text);
		return rv;
	}
	
	public static ResponseValue<String> success(){
		return success(TEXT_SUCCESS);
	}
	
	public static ResponseValue<String> error(String text){
		ResponseValue<String> rv = new ResponseValue<String>();
		rv.setState(false);
		rv.setCode(CODE_ERROR);
		rv.setMsg(text);
		return rv;
	}
	
	public static ResponseValue<String> error(){
		return error(TEXT_ERROR);
	}

	public static ResponseValue<String> error(int code, String text){
		if(code == CODE_SUCCESS){
			throw new IllegalArgumentException("错误代码不能是 '成功代码'");
		}
		ResponseValue<String> rv = new ResponseValue<String>();
		rv.setState(false);
		rv.setCode(code);
		rv.setMsg(text);
		return rv;
	}
	
	public static ResponseValue<String> relogin(){
		ResponseValue<String> rv = new ResponseValue<String>();
		rv.setState(true);
		rv.setCode(CODE_RELOGIN);
		rv.setMsg(TEXT_RELOGIN);
		return rv;
	}

	/**
	 * 添加异常响应类型，仅用户接口反馈，不需要用户看到。
	 * @return
	 * @date 2024-01-05
	 */
	public static ResponseValue<String> exception(){
		ResponseValue<String> rv = new ResponseValue<String>();
		rv.setState(false);
		rv.setCode(CODE_EXCEPTION);
		rv.setMsg(ResponseCode.EXCEPTION.getMessage());
		return rv;
	}
}
