package com.walker.web;

/**
 * 用户在线状态提供者接口规范定义。
 * <pre>
 *     1.通过该定义，可以根据token获取用户信息
 *     2.判断用户是否存在多个(相同)账号同时登录
 *     3.判断是否存在同一用户在不同设备上登录
 *     4.更新(或删除)用户登录缓存信息
 * </pre>
 * @author 时克英
 * @date 2022-11-01
 */
public interface UserOnlineProvider {

    /**
     * 根据token返回用户登录凭证对象
     * @param token
     * @return
     */
    UserPrincipal<?> getUserPrincipal(String token);

    /**
     * 缓存一个用户登录凭证与token关联信息
     * @param token
     * @param userPrincipal
     * @return
     */
    @Deprecated
    boolean cacheUserPrincipal(String token, UserPrincipal<?> userPrincipal);

    /**
     * 缓存一个用户登录凭证与token关联信息
     * @param token
     * @param userPrincipal
     * @param expiredMinutes token对应用户登录，缓存失效分钟。
     * @return
     * @date 2023-12-29
     */
    boolean cacheUserPrincipal(String token, UserPrincipal<?> userPrincipal, long expiredMinutes);

    /**
     * 更新用户访问时间
     * @param token
     * @return
     */
    boolean updateUserPrincipalTimeStamp(String token);

    /**
     * 删除用户缓存登录信息。
     * @param token 客户端存储的token，其实目前是 'uuid'
     * @return
     */
    boolean removeUserPrincipal(String token);
}
