package com.walker.web.captcha;

import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;

/**
 * 纯滑块验证码提供者，实现。
 * @author 时克英
 * @date 2023-03-14
 */
public class SlideCaptchaProvider implements CaptchaProvider<CaptchaResult> {

    @Override
    public CaptchaResult generateCaptcha(Object param) {
        return new CaptchaResult();
    }

    @Override
    public boolean validateCaptcha(CaptchaResult data) {
        // 滑块前端判断，后台不再需要。
        return true;
    }

    @Override
    public CaptchaType getCaptchaType() {
        return CaptchaType.Slide;
    }
}
