package com.walker.web.interceptor;

import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.Constants;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;


/**
 * Web操作拦截器定义。
 * @author 时克英
 * @date 2022-11-21
 */
public class WebOperationInterceptor implements HandlerInterceptor {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        // 返回contextPath后面的地址，如: http://localhost/demo/user/list --> /user/list
        String url = request.getServletPath();
        // 2023-01-28 如果带'/list'特征的地址认为是分页展示，准备接受分页信息
        if(url.indexOf(Constants.KEY_INTERCEPTOR_PAGE_LIST) >= 0){
            logger.debug("拦截器执行:preparePageSearch()");
            this.preparePageSearch(request);
        }
        return this.doPreHandleOther(url, request, response);
    }

    @Override
    public void afterCompletion(HttpServletRequest request,
                                HttpServletResponse response, Object args, Exception exception) throws Exception {
        // 1.清空分页请求线程参数，2022-11-21
        // 变量写入在控制器中，由业务方法自行调用: preparePageSearch()
        ListPageContext.clearPageSearch();
//        logger.debug("ListPageContext.clearPageSearch() = " + ListPageContext.getPageSearch());

        // 2.其他操作需要清空的变量。。。
    }

    /**
     * 业务覆盖方法，实现自己拦截业务。
     * @param servletPath
     * @param request
     * @param response
     * @return
     * @date 2023-03-09
     */
    protected boolean doPreHandleOther(String servletPath, HttpServletRequest request, HttpServletResponse response){
        return true;
    }

    private void preparePageSearch(HttpServletRequest request){
        PageSearch pageSearch = new PageSearch();
        String pn = request.getParameter(PageSearch.PAGE_NUM);
        if(StringUtils.isNotEmpty(pn)){
            pageSearch.setPageIndex(Integer.valueOf(pn));
        }
        String pageSize = request.getParameter(PageSearch.PAGE_SIZE);
        if(StringUtils.isNotEmpty(pageSize)){
            pageSearch.setPageSize(Integer.valueOf(pageSize));
        }
//        pageSearch.setOrderByColumn(request.getParameter(PageSearch.ORDER_BY_COLUMN));
//        pageSearch.setOrderAsc(request.getParameter(PageSearch.IS_ASC));

        // 2023-05-18 适配新前端（电商）分页
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        pn = request.getParameter(PageSearch.KEY_PAGE);
        if(StringUtils.isNotEmpty(pn)){
            pageSearch.setPageIndex(Integer.valueOf(pn));
        }
        pageSize = request.getParameter(PageSearch.KEY_PAGE_LIMIT);
        if(StringUtils.isNotEmpty(pageSize)){
            pageSearch.setPageSize(Integer.valueOf(pageSize));
        }
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        ListPageContext.setPageSearch(pageSearch);
    }
}
