/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import com.walker.web.WebRuntimeException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ERROR_MESSAGE = "\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38";

    @ExceptionHandler(value={WebRuntimeException.class})
    public ResponseValue<String> webRuntimeExceptionHandler(HttpServletRequest request, Exception e, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(200);
        WebRuntimeException webRuntimeException = (WebRuntimeException)((Object)e);
        String error = webRuntimeException.getMsg();
        if (StringUtils.isEmpty((String)error)) {
            error = ERROR_MESSAGE;
        }
        this.logger.error("\u4e1a\u52a1\u629b\u51faweb\u5f02\u5e38:" + webRuntimeException.getMessage(), (Throwable)e);
        return ResponseValue.exception();
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseValue<String> runtimeExceptionHandler(HttpServletRequest request, Exception e) {
        this.logger.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u8fd0\u884c\u5f02\u5e38.", (Object)request.getRequestURI(), (Object)e);
        return ResponseValue.exception();
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseValue<String> exceptionHandler(HttpServletRequest request, Exception e) {
        this.logger.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38.", (Object)request.getRequestURI(), (Object)e);
        return ResponseValue.exception();
    }
}

