/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web;

import com.walker.infrastructure.core.NamedThreadLocal;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public abstract class RequestAwareContext {
    private static boolean requestOverride = true;
    private static final NamedThreadLocal<HttpServletRequest> requestLocals = new NamedThreadLocal("walker_request_threadlocal");
    private static final NamedThreadLocal<HttpServletResponse> responseLocals = new NamedThreadLocal("walker_response_threadlocal");

    public static boolean isRequestOverride() {
        return requestOverride;
    }

    public static void setRequestOverride(boolean requestOverride) {
        RequestAwareContext.requestOverride = requestOverride;
    }

    public static void setCurrentRequest(HttpServletRequest request) {
        HttpServletRequest _r = (HttpServletRequest)requestLocals.get();
        if (_r != null) {
            if (!RequestAwareContext.isRequestOverride()) {
                throw new BindRequestRepeatException("request can't be binded repeatly! request = " + _r);
            }
            requestLocals.remove();
        }
        requestLocals.set((Object)request);
    }

    public static HttpServletRequest getCurrentRequest() {
        return (HttpServletRequest)requestLocals.get();
    }

    public static void clearCurrentRequest() {
        requestLocals.remove();
    }

    public static void setCurrentResponse(HttpServletResponse response) {
        HttpServletResponse _r = (HttpServletResponse)responseLocals.get();
        if (_r != null) {
            throw new IllegalStateException("response can't be binded repeatly! response = " + _r);
        }
        responseLocals.set((Object)response);
    }

    public static HttpServletResponse getCurrentResponse() {
        return (HttpServletResponse)responseLocals.get();
    }

    public static void clearCurrentResponse() {
        responseLocals.remove();
    }

    public static class BindRequestRepeatException
    extends IllegalStateException {
        private static final long serialVersionUID = -7221718348573512540L;

        public BindRequestRepeatException() {
            super("request can't be binded repeatly!");
        }

        public BindRequestRepeatException(String msg) {
            super(msg);
        }

        public BindRequestRepeatException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

