/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.web.RestTemplateConfig;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class RestTemplateFactory {
    public static final X509TrustManager IGNORE_SSL_TRUST_MANAGER_X509 = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    public static final RestTemplate createRestTemplate(HttpType httpType, RestTemplateConfig config) {
        if (config == null || httpType == null) {
            throw new IllegalArgumentException("\u8bf7\u63d0\u4f9b\u53c2\u6570");
        }
        if (httpType == HttpType.OkHttp) {
            try {
                return RestTemplateFactory.acquireHttpOkRestTemplate(config.getMaxIdleConnections(), config.getKeepAliveDurationSeconds(), config.getConnectTimeoutSeconds(), config.getReadTimeoutSeconds(), config.getWriteTimeoutSeconds());
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("\u521b\u5efa\uff1aRestTemplate\u5931\u8d25, " + e.getMessage(), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u5176\u4ed6\u65b9\u5f0fhttp\u8fde\u63a5");
    }

    private static RestTemplate acquireHttpOkRestTemplate(int maxIdleConnections, long keepAliveDuration, long connectTimeout, long readTimeout, long writeTimeout) throws Exception {
        ConnectionPool connectionPool = new ConnectionPool(maxIdleConnections, keepAliveDuration, TimeUnit.SECONDS);
        OkHttpClient client = new OkHttpClient().newBuilder().connectionPool(connectionPool).connectTimeout(connectTimeout, TimeUnit.SECONDS).readTimeout(readTimeout, TimeUnit.SECONDS).writeTimeout(writeTimeout, TimeUnit.SECONDS).sslSocketFactory(RestTemplateFactory.getIgnoreInitSslContext().getSocketFactory(), IGNORE_SSL_TRUST_MANAGER_X509).hostnameVerifier(RestTemplateFactory.getIgnoreSslHostnameVerifier()).build();
        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory(client);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        RestTemplateFactory.setupRestTemplate(restTemplate);
        return restTemplate;
    }

    private static void setupRestTemplate(RestTemplate restTemplate) {
        List messageConverters = restTemplate.getMessageConverters();
        Iterator iterator = messageConverters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter converter = (HttpMessageConverter)iterator.next();
            if (!(converter instanceof StringHttpMessageConverter)) continue;
            iterator.remove();
        }
        messageConverters.add(new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    public static SSLContext getIgnoreInitSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{IGNORE_SSL_TRUST_MANAGER_X509}, new SecureRandom());
        return sslContext;
    }

    public static HostnameVerifier getIgnoreSslHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
    }

    public static enum HttpType {
        OkHttp,
        HttpClient;

    }
}

