/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.agent;

import com.walker.web.WebAgentService;
import com.walker.web.WebUserAgent;
import com.walker.web.agent.BrowsCapField;
import com.walker.web.agent.Capabilities;
import com.walker.web.agent.UserAgentParser;
import com.walker.web.agent.UserAgentService;
import com.walker.web.util.IpUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;

public class BrowserCapWebAgentService
implements WebAgentService {
    private Capabilities capabilities = null;
    private UserAgentParser parser = null;
    private boolean loadLocation = false;

    public BrowserCapWebAgentService() {
        try {
            this.parser = new UserAgentService().loadParser(Arrays.asList(BrowsCapField.BROWSER, BrowsCapField.BROWSER_TYPE, BrowsCapField.BROWSER_MAJOR_VERSION, BrowsCapField.PLATFORM, BrowsCapField.PLATFORM_VERSION));
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u6d4f\u89c8\u5668\u89e3\u6790\u5bf9\u8c61\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    @Override
    public WebUserAgent getWebUserAgent(String userAgentText, HttpServletRequest request) {
        WebUserAgent webUserAgent = new WebUserAgent();
        if (this.parser == null) {
            return webUserAgent;
        }
        String ip = null;
        String location = "none";
        if (request != null) {
            ip = IpUtils.getIpAddr(request);
            if (this.loadLocation) {
                location = IpUtils.getLocationByIP(ip);
            }
        }
        Capabilities capabilities = this.parser.parse(userAgentText);
        webUserAgent.setBrowserName(capabilities.getBrowser());
        webUserAgent.setBrowserVersion(capabilities.getBrowserMajorVersion());
        webUserAgent.setDeviceType(capabilities.getDeviceType());
        webUserAgent.setOsName(capabilities.getPlatform());
        webUserAgent.setOsVersion(capabilities.getPlatformVersion());
        webUserAgent.setIp(ip);
        webUserAgent.setLocation(location);
        webUserAgent.setMethod(request.getMethod());
        webUserAgent.setUrl(request.getRequestURI());
        return webUserAgent;
    }

    public void setLoadLocation(boolean loadLocation) {
        this.loadLocation = loadLocation;
    }
}

