/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.agent;

import com.walker.web.agent.BrowsCapField;
import com.walker.web.agent.ParseException;
import com.walker.web.agent.UserAgentParser;
import com.walker.web.agent.impl.UserAgentFileParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UserAgentService {
    public static final int BUNDLED_BROWSCAP_VERSION = 6001002;
    private String myZipFilePath;
    private InputStream myZipFileStream;

    public UserAgentService() {
    }

    public UserAgentService(String zipFilePath) {
        this.myZipFilePath = zipFilePath;
    }

    public UserAgentService(InputStream zipFileStream) {
        this.myZipFileStream = zipFileStream;
    }

    public UserAgentParser loadParser() throws IOException, ParseException {
        Set<BrowsCapField> defaultFields = Stream.of(BrowsCapField.values()).filter(BrowsCapField::isDefault).collect(Collectors.toSet());
        return this.createParserWithFields(defaultFields);
    }

    public UserAgentParser loadParser(Collection<BrowsCapField> fields) throws IOException, ParseException {
        return this.createParserWithFields(fields);
    }

    private UserAgentParser createParserWithFields(Collection<BrowsCapField> fields) throws IOException, ParseException {
        try (InputStream zipStream = this.getCsvFileStream();
             ZipInputStream zipIn = new ZipInputStream(zipStream);){
            ZipEntry entry = null;
            while ((entry = zipIn.getNextEntry()) != null && !entry.getName().endsWith(".csv")) {
            }
            if (entry != null && !entry.isDirectory()) {
                UserAgentParser userAgentParser = UserAgentFileParser.parse(new InputStreamReader((InputStream)zipIn, StandardCharsets.UTF_8), fields);
                return userAgentParser;
            }
            throw new IOException("Unable to find the BrowsCap CSV file in the ZIP file");
        }
    }

    public static String getBundledCsvFileName() {
        return "browscap-6001002.zip";
    }

    private InputStream getCsvFileStream() throws FileNotFoundException {
        if (this.myZipFileStream == null) {
            if (this.myZipFilePath == null) {
                String csvFileName = UserAgentService.getBundledCsvFileName();
                return this.getClass().getClassLoader().getResourceAsStream(csvFileName);
            }
            return new FileInputStream(this.myZipFilePath);
        }
        return this.myZipFileStream;
    }
}

