/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.agent.impl;

import com.walker.web.agent.BrowsCapField;
import com.walker.web.agent.Capabilities;
import com.walker.web.agent.impl.Mapper;
import java.util.Arrays;
import java.util.Map;

public class CapabilitiesImpl
implements Capabilities {
    private final String[] myValues;
    private final Mapper myMapper;

    CapabilitiesImpl(String[] values, Mapper mapper) {
        this.myValues = values;
        this.myMapper = mapper;
    }

    @Override
    public String getValue(BrowsCapField field) {
        return this.myMapper.getValue(this.myValues, field);
    }

    @Override
    public String getBrowser() {
        return this.getValue(BrowsCapField.BROWSER);
    }

    @Override
    public String getBrowserType() {
        return this.getValue(BrowsCapField.BROWSER_TYPE);
    }

    @Override
    public String getBrowserMajorVersion() {
        return this.getValue(BrowsCapField.BROWSER_MAJOR_VERSION);
    }

    @Override
    public String getPlatform() {
        return this.getValue(BrowsCapField.PLATFORM);
    }

    @Override
    public String getPlatformVersion() {
        return this.getValue(BrowsCapField.PLATFORM_VERSION);
    }

    @Override
    public String getDeviceType() {
        return this.getValue(BrowsCapField.DEVICE_TYPE);
    }

    @Override
    public Map<BrowsCapField, String> getValues() {
        return this.myMapper.getAll(this.myValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myValues);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CapabilitiesImpl)) {
            return false;
        }
        CapabilitiesImpl other = (CapabilitiesImpl)obj;
        if (this.myMapper != other.myMapper) {
            return false;
        }
        return Arrays.equals(this.myValues, other.myValues);
    }

    public String toString() {
        return "CapabilitiesImpl [myValues=" + this.getValues() + "]";
    }
}

