/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.agent.impl;

import com.walker.web.agent.BrowsCapField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;

public class Mapper {
    private final Map<BrowsCapField, Integer> myIndices;

    Mapper(Collection<BrowsCapField> fields) {
        HashSet<BrowsCapField> all = new HashSet<BrowsCapField>(fields);
        for (BrowsCapField field : BrowsCapField.values()) {
            if (!field.isDefault()) continue;
            all.add(field);
        }
        this.myIndices = new EnumMap<BrowsCapField, Integer>(BrowsCapField.class);
        ArrayList<BrowsCapField> ordered = new ArrayList<BrowsCapField>(all);
        for (int i = 0; i < ordered.size(); ++i) {
            this.myIndices.put((BrowsCapField)((Object)ordered.get(i)), i);
        }
    }

    String[] getValues(Map<BrowsCapField, String> values) {
        String[] result = new String[this.myIndices.size()];
        this.put(result, BrowsCapField.BROWSER, "Default Browser");
        this.put(result, BrowsCapField.BROWSER_TYPE, "Default Browser");
        this.put(result, BrowsCapField.BROWSER_MAJOR_VERSION, "Unknown");
        this.put(result, BrowsCapField.DEVICE_TYPE, "Unknown");
        this.put(result, BrowsCapField.PLATFORM, "Unknown");
        this.put(result, BrowsCapField.PLATFORM_VERSION, "Unknown");
        for (Map.Entry<BrowsCapField, String> entry : values.entrySet()) {
            this.put(result, entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<BrowsCapField, String> getAll(String[] values) {
        EnumMap<BrowsCapField, String> result = new EnumMap<BrowsCapField, String>(BrowsCapField.class);
        for (BrowsCapField field : this.myIndices.keySet()) {
            result.put(field, this.getValue(values, field));
        }
        return result;
    }

    String getValue(String[] values, BrowsCapField field) {
        Integer index = this.myIndices.get((Object)field);
        if (index != null) {
            return values[index];
        }
        return null;
    }

    private void put(String[] values, BrowsCapField field, String value) {
        Integer index = this.myIndices.get((Object)field);
        if (index != null) {
            values[index.intValue()] = value;
        }
    }
}

