/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.agent.impl;

import com.walker.web.agent.Capabilities;
import com.walker.web.agent.impl.Literal;
import com.walker.web.agent.impl.SearchableString;

public class Rule {
    private final Literal myPrefix;
    private final Literal[] mySuffixes;
    private final Literal myPostfix;
    private final int mySize;
    private final Capabilities myCapabilities;

    Rule(Literal prefix, Literal[] suffixes, Literal postfix, String pattern, Capabilities capabilities) {
        this.myPrefix = prefix;
        this.mySuffixes = suffixes;
        this.myPostfix = postfix;
        this.myCapabilities = capabilities;
        this.mySize = pattern.length();
    }

    Literal getPrefix() {
        return this.myPrefix;
    }

    Literal[] getSuffixes() {
        return this.mySuffixes;
    }

    Literal getPostfix() {
        return this.myPostfix;
    }

    boolean requires(String value) {
        if (Rule.requires(this.myPrefix, value) || Rule.requires(this.myPostfix, value)) {
            return true;
        }
        if (this.mySuffixes == null) {
            return false;
        }
        for (Literal suffix : this.mySuffixes) {
            if (!Rule.requires(suffix, value)) continue;
            return true;
        }
        return false;
    }

    private static boolean requires(Literal literal, String value) {
        return literal != null && literal.requires(value);
    }

    Capabilities getCapabilities() {
        return this.myCapabilities;
    }

    int getSize() {
        return this.mySize;
    }

    final boolean matches(SearchableString value) {
        int end;
        int start;
        if (this.myPrefix == null) {
            start = 0;
        } else if (value.startsWith(this.myPrefix)) {
            start = this.myPrefix.getLength();
        } else {
            return false;
        }
        if (this.myPostfix == null) {
            end = value.getSize() - 1;
        } else if (value.endsWith(this.myPostfix)) {
            end = value.getSize() - 1 - this.myPostfix.getLength();
        } else {
            return false;
        }
        return Rule.checkWildCards(value, this.mySuffixes, start, end);
    }

    static boolean checkWildCards(SearchableString value, Literal[] suffixes, int start, int end) {
        if (suffixes == null) {
            return start == end + 1;
        }
        if (suffixes.length == 0) {
            return start <= end + 1;
        }
        int from = start;
        for (Literal suffix : suffixes) {
            int match = Rule.checkWildCard(value, suffix, from);
            if (match == -1) {
                return false;
            }
            from = suffix.getLength() + match;
            if (from <= end + 1) continue;
            return false;
        }
        return true;
    }

    private static int checkWildCard(SearchableString value, Literal suffix, int start) {
        for (int index : value.getIndices(suffix)) {
            if (index < start) continue;
            return index;
        }
        return -1;
    }

    String getPattern() {
        StringBuilder result = new StringBuilder();
        if (this.myPrefix != null) {
            result.append(this.myPrefix);
        }
        if (this.mySuffixes != null) {
            result.append("*");
            for (Literal sub : this.mySuffixes) {
                result.append(sub);
                result.append("*");
            }
        }
        if (this.myPostfix != null) {
            result.append(this.myPostfix);
        }
        return result.toString();
    }

    public String toString() {
        return this.getPattern() + " : " + this.myCapabilities;
    }
}

