/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.agent.impl;

import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.walker.web.agent.BrowsCapField;
import com.walker.web.agent.Capabilities;
import com.walker.web.agent.ParseException;
import com.walker.web.agent.UserAgentParser;
import com.walker.web.agent.impl.CapabilitiesImpl;
import com.walker.web.agent.impl.Literal;
import com.walker.web.agent.impl.LiteralDomain;
import com.walker.web.agent.impl.Mapper;
import com.walker.web.agent.impl.Rule;
import com.walker.web.agent.impl.UserAgentParserImpl;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserAgentFileParser {
    private final Map<String, Literal> myUniqueLiterals = new HashMap<String, Literal>();
    private final Map<Capabilities, Capabilities> myCache = new HashMap<Capabilities, Capabilities>();
    private final Map<String, String> myStrings = new HashMap<String, String>();
    private final Mapper myMapper;
    private final Set<BrowsCapField> myFields;
    private final LiteralDomain myDomain = new LiteralDomain();

    UserAgentFileParser(Collection<BrowsCapField> fields) {
        this.myFields = new HashSet<BrowsCapField>(fields);
        this.myMapper = new Mapper(this.myFields);
    }

    public static UserAgentParser parse(Reader input, Collection<BrowsCapField> fields) throws IOException, ParseException {
        return new UserAgentFileParser(fields).parse(input);
    }

    private UserAgentParser parse(Reader input) throws ParseException {
        Record record;
        ArrayList<Rule> rules = new ArrayList<Rule>();
        CsvParserSettings settings = new CsvParserSettings();
        CsvParser csvParser = new CsvParser(settings);
        csvParser.beginParsing(input);
        while ((record = csvParser.parseNextRecord()) != null) {
            Rule rule = this.getRule(record);
            if (rule == null) continue;
            rules.add(rule);
        }
        return new UserAgentParserImpl(rules.toArray(new Rule[0]), this.myDomain, this.getDefaultCapabilities());
    }

    Capabilities getDefaultCapabilities() {
        EnumMap<BrowsCapField, String> result = new EnumMap<BrowsCapField, String>(BrowsCapField.class);
        for (BrowsCapField field : this.myFields) {
            result.put(field, "Unknown");
        }
        return this.getCapabilities(result);
    }

    private Rule getRule(Record record) throws ParseException {
        if (record.getValues().length <= 47) {
            return null;
        }
        String pattern = UserAgentFileParser.normalizePattern(record.getString(0));
        try {
            Map<BrowsCapField, String> values = this.getBrowsCapFields(record);
            Capabilities capabilities = this.getCapabilities(values);
            Rule rule = this.createRule(pattern, capabilities);
            if (!pattern.equals(rule.getPattern())) {
                throw new ParseException("Unable to parse " + pattern);
            }
            return rule;
        }
        catch (IllegalStateException e) {
            throw new ParseException("Unable to parse " + pattern);
        }
    }

    private static String normalizePattern(String pattern) {
        String lowerCase = pattern.toLowerCase();
        if (lowerCase.contains("**")) {
            return lowerCase.replaceAll("\\*+", "*");
        }
        return lowerCase;
    }

    private Map<BrowsCapField, String> getBrowsCapFields(Record record) {
        EnumMap<BrowsCapField, String> values = new EnumMap<BrowsCapField, String>(BrowsCapField.class);
        for (BrowsCapField field : this.myFields) {
            values.put(field, this.getValue(record.getString(field.getIndex())));
        }
        return values;
    }

    String getValue(String value) {
        if (value == null) {
            return "Unknown";
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return "Unknown";
        }
        String cached = this.myStrings.get(trimmed);
        if (cached != null) {
            return cached;
        }
        this.myStrings.put(trimmed, trimmed);
        return trimmed;
    }

    Capabilities getCapabilities(Map<BrowsCapField, String> values) {
        CapabilitiesImpl result = new CapabilitiesImpl(this.myMapper.getValues(values), this.myMapper);
        Capabilities fromCache = this.myCache.get(result);
        if (fromCache != null) {
            return fromCache;
        }
        this.myCache.put(result, result);
        return result;
    }

    Literal getLiteral(String value) {
        return this.myUniqueLiterals.computeIfAbsent(value, this.myDomain::createLiteral);
    }

    LiteralDomain getDomain() {
        return this.myDomain;
    }

    Rule createRule(String pattern, Capabilities capabilities) {
        List<String> parts = UserAgentFileParser.getParts(pattern);
        if (parts.isEmpty()) {
            throw new IllegalStateException();
        }
        String first = parts.get(0);
        if (parts.size() == 1) {
            if ("*".equals(first)) {
                return this.getWildCardRule();
            }
            return new Rule(this.getLiteral(first), null, null, pattern, capabilities);
        }
        LinkedList<String> suffixes = new LinkedList<String>(parts);
        Literal prefix = null;
        if (!"*".equals(first)) {
            prefix = this.getLiteral(first);
            suffixes.remove(0);
        }
        String last = parts.get(parts.size() - 1);
        Literal postfix = null;
        if (!"*".equals(last)) {
            postfix = this.getLiteral(last);
            suffixes.removeLast();
        }
        suffixes.removeAll(Collections.singleton("*"));
        Literal[] suffixArray = new Literal[suffixes.size()];
        for (int i = 0; i < suffixArray.length; ++i) {
            suffixArray[i] = this.getLiteral(suffixes.get(i));
        }
        return new Rule(prefix, suffixArray, postfix, pattern, capabilities);
    }

    private Rule getWildCardRule() {
        EnumMap<BrowsCapField, String> fieldValues = new EnumMap<BrowsCapField, String>(BrowsCapField.class);
        for (BrowsCapField field : this.myFields) {
            if (field.isDefault()) continue;
            fieldValues.put(field, "Unknown");
        }
        Capabilities capabilities = this.getCapabilities(fieldValues);
        return new Rule(null, new Literal[0], null, "*", capabilities);
    }

    static List<String> getParts(String pattern) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder literal = new StringBuilder();
        for (char c : pattern.toCharArray()) {
            if (c == '*') {
                if (literal.length() != 0) {
                    parts.add(literal.toString());
                    literal.setLength(0);
                }
                parts.add(String.valueOf(c));
                continue;
            }
            literal.append(c);
        }
        if (literal.length() != 0) {
            parts.add(literal.toString());
            literal.setLength(0);
        }
        return parts;
    }
}

