/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.agent.impl;

import com.walker.web.agent.Capabilities;
import com.walker.web.agent.UserAgentParser;
import com.walker.web.agent.impl.Literal;
import com.walker.web.agent.impl.LiteralDomain;
import com.walker.web.agent.impl.Rule;
import com.walker.web.agent.impl.SearchableString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UserAgentParserImpl
implements UserAgentParser {
    static final String[] COMMON = new String[]{"-", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "profile", "player", "compatible", "android", "google", "tab", "transformer", "lenovo", "micro", "edge", "safari", "opera", "chrome", "firefox", "msie", "chromium", "cpu os ", "cpu iphone os ", "windows nt ", "mac os x ", "linux", "bsd", "windows phone", "iphone", "pad", "blackberry", "nokia", "alcatel", "ucbrowser", "mobile", "ie", "mercury", "samsung", "browser", "wow64", "silk", "lunascape", "crios", "epiphany", "konqueror", "version", "rv:", "build", "bot", "like gecko", "applewebkit", "trident", "mozilla", "windows nt 4", "windows nt 5.0", "windows nt 5.1", "windows nt 5.2", "windows nt 6.0", "windows nt 6.1", "windows nt 6.2", "windows nt 6.3", "windows nt 10.0", "android?4.0", "android?4.1", "android?4.2", "android?4.3", "android?4.4", "android?2.3", "android?5"};
    static final String[] FILTER_PREFIXES = new String[]{"mozilla/5.0", "mozilla/4"};
    private final Rule[] myRules;
    private final Filter[] myFilters;
    private final Capabilities myDefaultCapabilities;
    private final LiteralDomain myDomain;

    UserAgentParserImpl(Rule[] rules, LiteralDomain domain, Capabilities defaultCapabilities) {
        this.myDomain = domain;
        this.myRules = UserAgentParserImpl.getOrderedRules(rules);
        this.myFilters = this.buildFilters();
        this.myDefaultCapabilities = defaultCapabilities;
    }

    @Override
    public Capabilities parse(String userAgent) {
        if (userAgent == null || userAgent.length() == 0) {
            return this.myDefaultCapabilities;
        }
        SearchableString searchString = this.myDomain.getSearchableString(userAgent.toLowerCase());
        BitSet includes = this.getIncludeRules(searchString, this.myFilters);
        int i = includes.nextSetBit(0);
        while (i >= 0) {
            Rule rule = this.myRules[i];
            if (rule.matches(searchString)) {
                return rule.getCapabilities();
            }
            i = includes.nextSetBit(i + 1);
        }
        return this.myDefaultCapabilities;
    }

    BitSet getIncludeRules(SearchableString searchString, Filter[] filters) {
        BitSet excludes = new BitSet(this.myRules.length);
        for (Filter filter : filters) {
            filter.applyExcludes(searchString, excludes);
        }
        BitSet includes = excludes;
        includes.flip(0, this.myRules.length);
        return includes;
    }

    static Rule[] getOrderedRules(Rule[] rules) {
        Comparator<Rule> c = Comparator.comparing(Rule::getSize).reversed().thenComparing(Rule::getPattern);
        Rule[] result = Arrays.copyOf(rules, rules.length);
        Arrays.parallelSort(result, c);
        return result;
    }

    Filter[] buildFilters() {
        ArrayList<Filter> result = new ArrayList<Filter>();
        for (String pattern : FILTER_PREFIXES) {
            result.add(this.createPrefixFilter(pattern));
        }
        List commonFilters = ((Stream)Stream.of(COMMON).parallel()).map(this::createContainsFilter).collect(Collectors.toList());
        result.addAll(commonFilters);
        return result.toArray(new Filter[0]);
    }

    Filter createContainsFilter(String pattern) {
        Literal literal = this.myDomain.createLiteral(pattern);
        Predicate<SearchableString> pred = c -> c.getIndices(literal).length > 0;
        Predicate<Rule> matches = rule -> rule.requires(pattern);
        return new Filter(pred, matches);
    }

    Filter createPrefixFilter(String pattern) {
        Literal literal = this.myDomain.createLiteral(pattern);
        Predicate<SearchableString> pred = s -> s.startsWith(literal);
        Predicate<Rule> matches = rule -> {
            Literal prefix = rule.getPrefix();
            return prefix != null && prefix.toString().startsWith(pattern);
        };
        return new Filter(pred, matches);
    }

    class Filter {
        private final Predicate<SearchableString> myUserAgentPredicate;
        private final BitSet myMask;

        Filter(Predicate<SearchableString> userAgentPredicate, Predicate<Rule> patternPredicate) {
            this.myUserAgentPredicate = userAgentPredicate;
            this.myMask = new BitSet(UserAgentParserImpl.this.myRules.length);
            for (int i = 0; i < UserAgentParserImpl.this.myRules.length; ++i) {
                if (!patternPredicate.test(UserAgentParserImpl.this.myRules[i])) continue;
                this.myMask.set(i);
            }
        }

        void applyExcludes(SearchableString userAgent, BitSet resultExcludes) {
            if (!this.myUserAgentPredicate.test(userAgent)) {
                resultExcludes.or(this.myMask);
            }
        }
    }
}

