/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.interceptor;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.web.ResponseValue;
import com.walker.web.annotation.RepeatSubmit;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public abstract class RepeatSubmitInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            RepeatSubmit annotation = method.getAnnotation(RepeatSubmit.class);
            if (annotation != null && this.isRepeatSubmit(request, annotation)) {
                ResponseValue<String> rv = ResponseValue.success(annotation.message());
                ServletUtils.renderString(response, JsonUtils.objectToJsonString(rv));
                return false;
            }
            return true;
        }
        return true;
    }

    public abstract boolean isRepeatSubmit(HttpServletRequest var1, RepeatSubmit var2);
}

