/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.interceptor;

import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class WebOperationInterceptor
implements HandlerInterceptor {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String url = request.getServletPath();
        if (url.indexOf("/list") >= 0) {
            this.logger.debug("\u62e6\u622a\u5668\u6267\u884c:preparePageSearch()");
            this.preparePageSearch(request);
        }
        return this.doPreHandleOther(url, request, response);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object args, Exception exception) throws Exception {
        ListPageContext.clearPageSearch();
    }

    protected boolean doPreHandleOther(String servletPath, HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    private void preparePageSearch(HttpServletRequest request) {
        String pageSize;
        PageSearch pageSearch = new PageSearch();
        String pn = request.getParameter("pageNum");
        if (StringUtils.isNotEmpty((String)pn)) {
            pageSearch.setPageIndex(Integer.valueOf(pn).intValue());
        }
        if (StringUtils.isNotEmpty((String)(pageSize = request.getParameter("pageSize")))) {
            pageSearch.setPageSize(Integer.valueOf(pageSize).intValue());
        }
        if (StringUtils.isNotEmpty((String)(pn = request.getParameter("page")))) {
            pageSearch.setPageIndex(Integer.valueOf(pn).intValue());
        }
        if (StringUtils.isNotEmpty((String)(pageSize = request.getParameter("limit")))) {
            pageSearch.setPageSize(Integer.valueOf(pageSize).intValue());
        }
        ListPageContext.setPageSearch((PageSearch)pageSearch);
    }
}

