/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.token;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.TokenException;
import com.walker.web.TokenGenerator;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.util.Date;
import java.util.HashMap;

public class JwtTokenGenerator
implements TokenGenerator {
    private static final long ONE_MINUTE_MILLS = 60000L;

    @Override
    public String createToken(String userId, long expiredMinutes, String magicKey) {
        return this.createToken(null, userId, expiredMinutes, magicKey);
    }

    @Override
    public String createToken(String userKey, String userId, long expiredMinutes, String magicKey) {
        if (StringUtils.isEmpty((String)userId)) {
            throw new IllegalArgumentException("createToken error: userId is required!");
        }
        JwtBuilder builder = Jwts.builder().setIssuer("walkersoft").setIssuedAt(new Date());
        HashMap<String, String> claims = new HashMap<String, String>(2);
        if (StringUtils.isNotEmpty((String)userKey)) {
            claims.put("login_user_key", userKey);
            claims.put("user_id_key", userId);
        } else {
            claims.put("user_id_key", userId);
        }
        builder.addClaims(claims);
        builder.signWith(SignatureAlgorithm.HS512, magicKey);
        long expiredTime = 0L;
        if (expiredMinutes > 0L) {
            expiredTime = System.currentTimeMillis() + expiredMinutes * 60000L;
            builder.setExpiration(new Date(expiredTime));
            logger.debug("token \u8fc7\u671f\u65f6\u95f4:" + expiredTime);
        }
        return builder.compact();
    }

    @Override
    public String validateToken(String token, String secretKey) throws TokenException {
        try {
            Claims c = (Claims)Jwts.parser().setSigningKey(secretKey).parseClaimsJws(token).getBody();
            if (c == null) {
                throw new TokenException("token claims is null!");
            }
            StringBuilder sb = new StringBuilder(c.get((Object)"user_id_key").toString());
            if (c.get((Object)"login_user_key") != null) {
                sb.append(",");
                sb.append(c.get((Object)"login_user_key").toString());
            }
            return sb.toString();
        }
        catch (Exception ex) {
            if (ex instanceof SignatureException) {
                throw new TokenException("token\u7b7e\u540d\u89e3\u6790\u9519\u8bef", ex);
            }
            if (ex instanceof ExpiredJwtException) {
                throw new TokenException("token\u8fc7\u671f", ex, true);
            }
            throw new TokenException(ex.getMessage(), ex);
        }
    }

    @Override
    public String acquireSecretKey() {
        return null;
    }
}

