/*
 * Decompiled with CFR 0.152.
 */
package com.walker.web.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.util.HttpUtils;
import com.walker.web.util.Location;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class IpUtils {
    protected static final transient Logger logger = LoggerFactory.getLogger(IpUtils.class);
    public static final String UNKNOWN_TEXT = "unknown";
    public static final String LOCALHOST = "127.0.0.1";
    public static final String IP_URL = "http://whois.pconline.com.cn/ipJson.jsp";
    private static final String LOCATION_URL_TAOBAO = "http://ip.taobao.com/outGetIpInfo";

    public static String getIpAddr(HttpServletRequest request) {
        if (request == null) {
            return UNKNOWN_TEXT;
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || UNKNOWN_TEXT.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN_TEXT.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN_TEXT.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN_TEXT.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN_TEXT.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? LOCALHOST : IpUtils.getMultistageReverseProxyIp(ip);
    }

    public static boolean internalIp(String ip) {
        byte[] addr = IpUtils.textToNumericFormatV4(ip);
        return IpUtils.internalIp(addr) || LOCALHOST.equals(ip);
    }

    private static boolean internalIp(byte[] addr) {
        if (addr == null || addr.length < 2) {
            return true;
        }
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static byte[] textToNumericFormatV4(String text) {
        if (text.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[4];
        String[] elements = text.split("\\.", -1);
        try {
            switch (elements.length) {
                case 1: {
                    long l = Long.parseLong(elements[0]);
                    if (l < 0L || l > 0xFFFFFFFFL) {
                        return null;
                    }
                    bytes[0] = (byte)(l >> 24 & 0xFFL);
                    bytes[1] = (byte)((l & 0xFFFFFFL) >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 2: {
                    long l = Integer.parseInt(elements[0]);
                    if (l < 0L || l > 255L) {
                        return null;
                    }
                    bytes[0] = (byte)(l & 0xFFL);
                    l = Integer.parseInt(elements[1]);
                    if (l < 0L || l > 0xFFFFFFL) {
                        return null;
                    }
                    bytes[1] = (byte)(l >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 3: {
                    long l;
                    for (int i = 0; i < 2; ++i) {
                        l = Integer.parseInt(elements[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                    }
                    l = Integer.parseInt(elements[2]);
                    if (l < 0L || l > 65535L) {
                        return null;
                    }
                    bytes[2] = (byte)(l >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long l = Integer.parseInt(elements[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return bytes;
    }

    public static String getHostIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return LOCALHOST;
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "\u672a\u77e5";
        }
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (IpUtils.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return StringUtils.isEmpty((String)checkString) || UNKNOWN_TEXT.equalsIgnoreCase(checkString);
    }

    public static String getLocationByIP(String ip) {
        if (IpUtils.internalIp(ip)) {
            return "\u5185\u7f51IP";
        }
        try {
            String rspStr = HttpUtils.sendGet(IP_URL, "ip=" + ip + "&json=true", "GBK");
            if (StringUtils.isEmpty((String)rspStr)) {
                logger.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
                return UNKNOWN_TEXT;
            }
            ObjectNode objectNode = JsonUtils.jsonStringToObjectNode((String)rspStr);
            if (objectNode == null) {
                return "";
            }
            String region = objectNode.get("pro").asText();
            String city = objectNode.get("city").asText();
            return String.format("%s %s", region, city);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
            return "";
        }
    }

    public static final Location getLocationAli(String ip, RestTemplate restTemplate) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ip", ip);
        map.put("accessKey", "alibaba-inc");
        try {
            ResponseEntity entity = restTemplate.postForEntity(LOCATION_URL_TAOBAO, map, String.class, new Object[0]);
            if (!entity.getStatusCode().is2xxSuccessful()) {
                logger.error("ip\u8fdc\u7a0b\u83b7\u53d6locatioin\u9519\u8bef:" + (String)entity.getBody());
                return null;
            }
            String data = (String)entity.getBody();
            if (StringUtils.isEmpty((String)data)) {
                logger.error("ip\u83b7\u53d6location\u8fdc\u7a0b\u8fd4\u56de\u7a7a\u6570\u636e\uff0cip = " + ip);
                return null;
            }
            Map locationMap = (Map)JsonUtils.jsonStringToObject((String)data, Map.class);
            if ("query success".equals(locationMap.get("msg").toString())) {
                Location location = new Location();
                location.setCountry(locationMap.get("country").toString());
                location.setCity(locationMap.get("city").toString());
                location.setRegion(locationMap.get("region").toString());
                return location;
            }
            return null;
        }
        catch (Exception ex) {
            logger.error("ip\u83b7\u53d6location\u9519\u8bef:" + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

