/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

// aynalar kırıldı aynalara inanmadım aynalar kandırdı her zaman ben hiç kırılmadım.
/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public interface BiTreeSet<Q> extends SortedSet<Q>, Serializable {

    /**
     * @param object
     * @return
     */
    public boolean containsFamily(Q object);

    /**
     * @param collection
     * @return
     */
    public boolean containsAllFamily(Collection<Q> collection);

    /**
     * @param item
     */
    public void removeFamily(Q item);

    /**
     * @param collection
     */
    public void removeAllFamily(Collection<? extends Q> collection);

    /**
     * @return
     */
    public Iterator<Q> lastFamily();

    /**
     * @return
     */
    public Iterator<Q> firstFamily();

    @Override
    public Spliterator<Q> spliterator();

    @Override
    public Q last();

    @Override
    public Q first();

    @Override
    public SortedSet<Q> tailSet(Q fromElement);

    @Override
    public SortedSet<Q> headSet(Q toElement);

    @Override
    public SortedSet<Q> subSet(Q fromElement, Q toElement);

    @Override
    public Comparator<? super Q> comparator();

    @Override
    public void clear();

    @Override
    public boolean removeAll(Collection<?> collection);

    @Override
    public boolean remove(Object object);

    @Override
    public boolean retainAll(Collection<?> collection);

    @Override
    public boolean addAll(Collection<? extends Q> collection);

    @Override
    public boolean contains(Object object);

    @Override
    public boolean containsAll(Collection<?> collection);

    @Override
    public boolean add(Q e);

    @Override
    public <T> T[] toArray(T[] a);

    @Override
    public Object[] toArray();

    @Override
    public Iterator<Q> iterator();

    @Override
    public boolean isEmpty();

    @Override
    public int size();

    @Override
    public Stream<Q> parallelStream();

    @Override
    public Stream<Q> stream();

    @Override
    public boolean removeIf(Predicate<? super Q> filter);

    @Override
    public void forEach(Consumer<? super Q> action);
}
